/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileModel
implements DasModel {
    private final MultiMap<DasObject, DasObject> myChildren;
    private final MultiMap<DasTable, DasConstraint> myExported;
    private final List<DasObject> myRoots;
    private final DasNamespace myCurrentRootNamespace;
    private final SqlFile myFile;

    public SqlFileModel(@NotNull SqlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/models/SqlFileModel", "<init>"));
        }
        this.myChildren = MultiMap.createLinkedSet();
        this.myExported = MultiMap.createLinkedSet();
        this.myRoots = ContainerUtil.newArrayList();
        for (DasObject object : file.traverser().bfsTraversal()) {
            DasForeignKey foreignKey;
            DasTable target;
            DasObject parent = object.getDbParent();
            if (object instanceof DasForeignKey && (target = (foreignKey = (DasForeignKey)object).getRefTable()) != null) {
                this.myExported.putValue((Object)target, (Object)foreignKey);
            }
            if (parent == null) continue;
            this.myChildren.putValue((Object)parent, (Object)object);
        }
        ContainerUtil.addAll(this.myRoots, (Iterable)file.getModelRoots());
        this.myCurrentRootNamespace = (DasNamespace)ObjectUtils.tryCast((Object)DatabaseEditorHelper.getForcedContext((PsiFile)file), DasNamespace.class);
        this.myFile = file;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(this.myRoots);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/SqlFileModel", "getModelRoots"));
        }
        return jBIterable;
    }

    @Nullable
    public DasNamespace getCurrentRootNamespace() {
        return this.myCurrentRootNamespace;
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(this.TREE_STRUCTURE()).withRoots(this.myRoots);
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/SqlFileModel", "traverser"));
        }
        return jBTreeTraverser;
    }

    @NotNull
    private Function<DasObject, Iterable<? extends DasObject>> TREE_STRUCTURE() {
        Function function = arg_0 -> this.myChildren.get(arg_0);
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/SqlFileModel", "TREE_STRUCTURE"));
        }
        return function;
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        JBIterable jBIterable = JBIterable.from((Iterable)this.myExported.get((Object)table));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/SqlFileModel", "getExportedKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/view/models/SqlFileModel", "getCasing"));
        }
        Casing casing = this.myFile.getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/SqlFileModel", "getCasing"));
        }
        return casing;
    }
}

