/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableChildEditorModel;
import com.intellij.sql.util.NameTemplate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForeignKeyEditorModel
extends TableChildEditorModel<DeForeignKey> {
    private final EditorModelUtil.GeneratedNameHelper myGenHelper;

    public ForeignKeyEditorModel(@NotNull DeForeignKey object, @NotNull EditorModelsCache models) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/ForeignKeyEditorModel", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/ForeignKeyEditorModel", "<init>"));
        }
        super(object, models);
        this.fix();
        this.myGenHelper = new EditorModelUtil.GeneratedNameHelper(object, (NameTemplate)new NameTemplate.ForeignKeyNameTemplate(models.settings));
        this.myGenHelper.updateGenerated();
    }

    private void fix() {
        ((DeForeignKey)this.myObject).target = EditorModelUtil.stubbize(((DeForeignKey)this.myObject).target, null, ((DeForeignKey)this.myObject).model);
        List<DeForeignKey.Ref> refs = ((DeForeignKey)this.myObject).refs;
        for (int i2 = 0; i2 < refs.size(); ++i2) {
            DeForeignKey.Ref ref = refs.get(i2);
            if (ref.ref != null && ref.target != null) continue;
            refs.set(i2, new DeForeignKey.Ref(EditorModelUtil.stubbize(ref.ref, ((DeForeignKey)this.myObject).table, ((DeForeignKey)this.myObject).model), EditorModelUtil.stubbize(ref.target, ((DeForeignKey)this.myObject).table, ((DeForeignKey)this.myObject).model)));
        }
    }

    @NotNull
    public List<DeForeignKey.Ref> getRefs() {
        List<DeForeignKey.Ref> list = Collections.unmodifiableList(((DeForeignKey)this.myObject).refs);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ForeignKeyEditorModel", "getRefs"));
        }
        return list;
    }

    public void setRefs(@NotNull List<DeForeignKey.Ref> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/database/view/models/ForeignKeyEditorModel", "setRefs"));
        }
        if (((DeForeignKey)this.myObject).refs.equals(refs)) {
            return;
        }
        ((DeForeignKey)this.myObject).refs.clear();
        ((DeForeignKey)this.myObject).refs.addAll(refs);
        this.modify();
    }

    @NotNull
    public DasForeignKey.RuleAction getUpdateRule() {
        DasForeignKey.RuleAction ruleAction = ((DeForeignKey)this.myObject).updateRule;
        if (ruleAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ForeignKeyEditorModel", "getUpdateRule"));
        }
        return ruleAction;
    }

    @NotNull
    public DasForeignKey.RuleAction getDeleteRule() {
        DasForeignKey.RuleAction ruleAction = ((DeForeignKey)this.myObject).deleteRule;
        if (ruleAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ForeignKeyEditorModel", "getDeleteRule"));
        }
        return ruleAction;
    }

    @NotNull
    public DasForeignKey.Deferrability getDeferrability() {
        DasForeignKey.Deferrability deferrability = ((DeForeignKey)this.myObject).deferrability;
        if (deferrability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ForeignKeyEditorModel", "getDeferrability"));
        }
        return deferrability;
    }

    public void setUpdateRule(@NotNull DasForeignKey.RuleAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/view/models/ForeignKeyEditorModel", "setUpdateRule"));
        }
        if (action == ((DeForeignKey)this.myObject).updateRule) {
            return;
        }
        ((DeForeignKey)this.myObject).updateRule = action;
        this.modify();
    }

    public void setDeleteRule(@NotNull DasForeignKey.RuleAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/view/models/ForeignKeyEditorModel", "setDeleteRule"));
        }
        if (action == ((DeForeignKey)this.myObject).deleteRule) {
            return;
        }
        ((DeForeignKey)this.myObject).deleteRule = action;
        this.modify();
    }

    public void setDeferrability(@NotNull DasForeignKey.Deferrability deferrability) {
        if (deferrability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deferrability", "com/intellij/database/view/models/ForeignKeyEditorModel", "setDeferrability"));
        }
        if (deferrability == ((DeForeignKey)this.myObject).deferrability) {
            return;
        }
        ((DeForeignKey)this.myObject).deferrability = deferrability;
        this.modify();
    }

    public int getRefsCount() {
        return ((DeForeignKey)this.myObject).refs.size();
    }

    @Nullable
    public DeTable getTargetTable() {
        return ((DeForeignKey)this.myObject).target;
    }

    public void setTargetTable(@Nullable DeTable target) {
        if (target == ((DeForeignKey)this.myObject).target) {
            return;
        }
        ((DeForeignKey)this.myObject).target = target;
        this.modify();
    }

    @Override
    public void commit() {
        if (this.myGenHelper.updateGenerated()) {
            this.modify();
        }
        super.commit();
    }
}

