/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.util.Key;
import com.intellij.sql.util.NameTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorModelUtil {
    private static final Key<Boolean> STUB_FLAG = Key.create((String)"STUB_FLAG");

    @NotNull
    public static DeTable stubbize(@Nullable DeTable table, @Nullable DeObject parent, @NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        if (table != null) {
            DeTable deTable = table;
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
            }
            return deTable;
        }
        DeTable deTable = EditorModelUtil.setStub(new DeTable("", parent, model));
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        return deTable;
    }

    @NotNull
    public static DeColumn stubbize(@Nullable DeColumn column, @NotNull DeTable parent, @NotNull DeModel model) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        DeColumn deColumn = EditorModelUtil.stubbize(column, "", parent, model);
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        return deColumn;
    }

    @NotNull
    public static DeColumn stubbize(@Nullable DeColumn column, @NotNull String name, @NotNull DeTable parent, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        if (column != null) {
            DeColumn deColumn = column;
            if (deColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
            }
            return deColumn;
        }
        DeColumn deColumn = EditorModelUtil.setStub(new DeColumn(name, parent, model));
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelUtil", "stubbize"));
        }
        return deColumn;
    }

    @NotNull
    public static <De extends DeObject> De setStub(@NotNull De object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/EditorModelUtil", "setStub"));
        }
        STUB_FLAG.set(object.flags, (Object)Boolean.TRUE);
        De De = object;
        if (De == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelUtil", "setStub"));
        }
        return De;
    }

    public static boolean isStub(@Nullable DeObject object) {
        return object == null || STUB_FLAG.get(object.flags) == Boolean.TRUE;
    }

    public static class GeneratedNameHelper {
        private final DeObject myObject;
        private final NameTemplate myTemplate;
        private String myGenerated;

        public GeneratedNameHelper(@NotNull DeObject object, @NotNull NameTemplate template) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/EditorModelUtil$GeneratedNameHelper", "<init>"));
            }
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/models/EditorModelUtil$GeneratedNameHelper", "<init>"));
            }
            this.myObject = object;
            this.myTemplate = template;
            this.myGenerated = this.myTemplate.getName((DasObject)this.myObject);
        }

        private boolean isNotGeneratedYet() {
            return this.myObject.name.isEmpty() && (this.myObject.editedObject == null || !this.myObject.editedObject.getName().isEmpty());
        }

        public boolean updateGenerated() {
            boolean updateObject = this.isNotGeneratedYet() || this.myObject.getName().equals(this.myGenerated);
            String generated = this.myTemplate.getName((DasObject)this.myObject);
            if (generated.equals(this.myObject.name)) {
                return false;
            }
            this.myGenerated = generated;
            if (updateObject) {
                this.myObject.name = this.myGenerated;
            }
            return updateObject;
        }
    }
}

