/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableChildEditorModel;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnEditorModel
extends TableChildEditorModel<DeColumn> {
    public ColumnEditorModel(@NotNull DeColumn object, @NotNull EditorModelsCache models) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/ColumnEditorModel", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/ColumnEditorModel", "<init>"));
        }
        super(object, models);
    }

    public void setDataType(@NotNull String dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/view/models/ColumnEditorModel", "setDataType"));
        }
        if (dataType.equals(((DeColumn)this.myObject).dataType)) {
            return;
        }
        ((DeColumn)this.myObject).dataType = dataType;
        this.modify();
    }

    public void setDefault(@Nullable String defaultValue) {
        if (Comparing.equal((String)defaultValue, (String)((DeColumn)this.myObject).defaultValue)) {
            return;
        }
        ((DeColumn)this.myObject).defaultValue = defaultValue;
        this.modify();
    }

    public void setNotNull(boolean notNull) {
        this.setFlag(DeColumn.Flag.NOT_NULL, notNull);
    }

    public void setAutoInc(boolean autoInc) {
        this.setFlag(DeColumn.Flag.AUTO_INC, autoInc);
    }

    protected void setFlag(@NotNull DeColumn.Flag flag, boolean on) {
        if (flag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flag", "com/intellij/database/view/models/ColumnEditorModel", "setFlag"));
        }
        if (((DeColumn)this.myObject).flags.contains((Object)flag) == on) {
            return;
        }
        if (on) {
            ((DeColumn)this.myObject).flags.add(flag);
        } else {
            ((DeColumn)this.myObject).flags.remove((Object)flag);
        }
        this.modify();
    }

    @NotNull
    public String getDataType() {
        String string = ((DeColumn)this.myObject).dataType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ColumnEditorModel", "getDataType"));
        }
        return string;
    }

    public boolean isNotNull() {
        return ((DeColumn)this.myObject).flags.contains((Object)DeColumn.Flag.NOT_NULL);
    }

    public boolean isAutoInc() {
        return ((DeColumn)this.myObject).flags.contains((Object)DeColumn.Flag.AUTO_INC);
    }

    @Nullable
    public String getDefault() {
        return ((DeColumn)this.myObject).defaultValue;
    }
}

