/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasIndex;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseIndexEditor;
import com.intellij.database.view.editors.EmbComboBox;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DatabaseIndexColumnEditor
implements DatabaseEditorUtil.EmbeddableEditor {
    private final DatabaseIndexEditor myIndexEditor;
    private final DatabaseEditorCapabilities.IndexColumnEditorCaps myCaps;
    private JPanel myPanel;
    private EditorTextField myColumnEditorComponent;
    private JComboBox mySorting;
    private final DatabaseColumnRefEditor myColumnEditor;
    private boolean myValid;

    public DatabaseIndexColumnEditor(@NotNull DatabaseIndexEditor indexEditor, @NotNull DatabaseEditorCapabilities.IndexColumnEditorCaps caps) {
        if (indexEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexEditor", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "<init>"));
        }
        this.myIndexEditor = indexEditor;
        this.myCaps = caps;
        this.myColumnEditor = new DatabaseColumnRefEditor(this.myIndexEditor.getContext());
        this.$$$setupUI$$$();
        this.myColumnEditorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!((DatabaseIndexColumnEditor)DatabaseIndexColumnEditor.this).myIndexEditor.myUpdating) {
                    ArrayList items = ContainerUtil.newArrayList(DatabaseIndexColumnEditor.this.getIndexModel().getItems());
                    int index = DatabaseIndexColumnEditor.this.myIndexEditor.getIndex(DatabaseIndexColumnEditor.this);
                    DeColumn item = DatabaseIndexColumnEditor.this.getColumn();
                    items.set(index, new DeIndex.Item(item, ((DeIndex.Item)items.get((int)index)).sorting));
                    DatabaseIndexColumnEditor.this.getIndexModel().setItems(items);
                    DatabaseIndexColumnEditor.this.getIndexModel().commit();
                }
            }
        });
        this.mySorting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!((DatabaseIndexColumnEditor)DatabaseIndexColumnEditor.this).myIndexEditor.myUpdating) {
                    ArrayList items = ContainerUtil.newArrayList(DatabaseIndexColumnEditor.this.getIndexModel().getItems());
                    int index = DatabaseIndexColumnEditor.this.myIndexEditor.getIndex(DatabaseIndexColumnEditor.this);
                    items.set(index, new DeIndex.Item(((DeIndex.Item)items.get((int)index)).column, (DasIndex.Sorting)e.getItem()));
                    DatabaseIndexColumnEditor.this.getIndexModel().setItems(items);
                    DatabaseIndexColumnEditor.this.getIndexModel().commit();
                }
            }
        });
        this.mySorting.setEnabled(this.myCaps.getSorting().isAvailable());
    }

    @NotNull
    public IndexEditorModel getIndexModel() {
        IndexEditorModel indexEditorModel = this.myIndexEditor.getIndexModel();
        if (indexEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getIndexModel"));
        }
        return indexEditorModel;
    }

    @NotNull
    public DeIndex.Item getItem() {
        DeIndex.Item item = this.myIndexEditor.getIndex().items.get(this.myIndexEditor.getIndex(this));
        if (item == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getItem"));
        }
        return item;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        String sorting = this.getSorting();
        DeColumn column = this.getColumn();
        Iterable<Pair<String, TextAttributesKey>> iterable = new DatabaseEditorUtil.ColoredFragmentsBuilder().appendRef(this.myIndexEditor.getObjectName(column), DatabaseEditorBaseEx.isGood(column)).append((sorting.isEmpty() ? "" : " ") + sorting).build();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getRowText"));
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myValid;
    }

    @NotNull
    public String getSorting() {
        Object item = this.mySorting.getSelectedItem();
        if (item == DasIndex.Sorting.ASCENDING) {
            if ("ASC" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getSorting"));
            }
            return "ASC";
        }
        if (item == DasIndex.Sorting.DESCENDING) {
            if ("DESC" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getSorting"));
            }
            return "DESC";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getSorting"));
        }
        return "";
    }

    @Override
    public boolean canDoAnything() {
        return true;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myColumnEditorComponent.getFocusTarget();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myColumnEditorComponent.getFocusTarget(), this.mySorting};
        if (jComponentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getFocusableComponents"));
        }
        return jComponentArray;
    }

    @NotNull
    public DeColumn getColumn() {
        DeColumn deColumn = this.myColumnEditor.getObjectOrStub(this.myIndexEditor.getTable());
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getColumn"));
        }
        return deColumn;
    }

    public void updateFromModel(int idx) {
        DeIndex.Item item = this.getIndexModel().getItems().get(idx);
        this.myColumnEditor.setTable(this.myIndexEditor.getTable());
        this.myColumnEditor.setObject(item.column);
        this.mySorting.setSelectedItem(item.sorting);
        this.myValid = item.column != null && !EditorModelUtil.isStub(item.column) && item.column.isInTable();
    }

    @NotNull
    public EditorTextField getColumnEditor() {
        EditorTextField editorTextField = this.myColumnEditorComponent;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getColumnEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public JComboBox getSortingEditor() {
        JComboBox jComboBox = this.mySorting;
        if (jComboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getSortingEditor"));
        }
        return jComboBox;
    }

    private void createUIComponents() {
        this.myColumnEditorComponent = this.myColumnEditor.getEditor();
        this.mySorting = new EmbComboBox((ComboBoxModel)new DefaultComboBoxModel<DasIndex.Sorting>(DasIndex.Sorting.values()));
        this.mySorting.setRenderer(EmbComboBox.ENUM_RENDERER);
    }

    @NotNull
    public DatabaseIndexEditor getIndexEditor() {
        DatabaseIndexEditor databaseIndexEditor = this.myIndexEditor;
        if (databaseIndexEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseIndexColumnEditor", "getIndexEditor"));
        }
        return databaseIndexEditor;
    }

    public DatabaseEditorCapabilities.IndexColumnEditorCaps getCaps() {
        return this.myCaps;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myColumnEditorComponent;
        jPanel.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Sorting:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.mySorting;
        jPanel.add((Component)jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

