/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectRefEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseColumnRefEditor
extends DatabaseObjectRefEditor<DeColumn> {
    private DeTable myTable;
    private DeColumn myStubCache;

    public DatabaseColumnRefEditor(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/editors/DatabaseColumnRefEditor", "<init>"));
        }
        super(context);
        this.myTable = null;
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull DeColumn item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseColumnRefEditor", "getIcon"));
        }
        return DatabaseIcons.Col;
    }

    public void setTable(@Nullable DeTable table) {
        if (this.myTable == table) {
            return;
        }
        this.myTable = table;
        this.setItems(table == null ? JBIterable.empty() : JBIterable.from(this.myTable.columns));
    }

    @NotNull
    public DeColumn getObjectOrStub(@NotNull DeTable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/view/editors/DatabaseColumnRefEditor", "getObjectOrStub"));
        }
        DeColumn res = (DeColumn)this.getObject(JBIterable.from(parent.columns));
        if (res == null) {
            String name = this.getName();
            if (this.myStubCache == null || !this.myStubCache.name.equals(name)) {
                this.myStubCache = DatabaseColumnRefEditor.createStub(name, parent);
            }
            res = this.myStubCache;
        }
        DeColumn deColumn = res;
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnRefEditor", "getObjectOrStub"));
        }
        return deColumn;
    }

    @NotNull
    public static DeColumn createStub(@NotNull String name, @NotNull DeTable parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/editors/DatabaseColumnRefEditor", "createStub"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/view/editors/DatabaseColumnRefEditor", "createStub"));
        }
        DeColumn deColumn = EditorModelUtil.setStub(new DeColumn(name, parent, parent.model));
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnRefEditor", "createStub"));
        }
        return deColumn;
    }
}

