/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectPath {
    public final ObjectKind kind;
    public final List<String> path;

    public ObjectPath(@NotNull ObjectKind kind, @NotNull List<String> path) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/vfs/ObjectPath", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/vfs/ObjectPath", "<init>"));
        }
        this.kind = kind;
        this.path = Arrays.asList(ArrayUtil.toStringArray(path));
    }

    @NotNull
    public String getDisplayName() {
        String string = StringUtil.join((Iterable)JBIterable.from(this.path).filter(QNameUtil.NOT_EMPTY), (String)".");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/ObjectPath", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.path.isEmpty() ? "" : this.path.get(this.path.size() - 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/ObjectPath", "getName"));
        }
        return string;
    }

    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable DasObject o) {
        if (o == null) {
            return null;
        }
        List parents = ContainerUtil.reverse((List)DasUtil.dasParents((DasObject)o).filter(x -> x.getKind() != ObjectKind.ROOT).toList());
        return new ObjectPath(o.getKind(), JBIterable.from((Iterable)parents).transform(DasUtil.TO_NAME).toList());
    }

    @Contract(value="!null->!null")
    public static String serialize(@Nullable ObjectPath o) {
        if (o == null) {
            return null;
        }
        return o.kind.code() + "/" + StringUtil.join(o.path, DatabaseElementVirtualFileImpl.ESCAPER, (String)".");
    }

    @Nullable
    public static ObjectPath deserialize(@Nullable String o, @NotNull MetaModel metaModel) {
        if (metaModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaModel", "com/intellij/database/vfs/ObjectPath", "deserialize"));
        }
        if (o == null) {
            return null;
        }
        int idx = o.indexOf("/");
        if (idx < 0) {
            return new ObjectPath(ObjectKind.NONE, Collections.singletonList(o));
        }
        ObjectKind kind = metaModel.findKind(o.substring(0, idx));
        return new ObjectPath(kind == null ? ObjectKind.NONE : kind, Arrays.asList(DatabaseElementVirtualFileImpl.decodeQName(o.substring(idx + 1))));
    }

    public String toString() {
        return this.kind + ":" + this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPath path1 = (ObjectPath)o;
        if (!this.kind.equals(path1.kind)) {
            return false;
        }
        return this.path.equals(path1.path);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }
}

