/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.DataSourceStorageFileType;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFileTypeFactoryBase
extends FileTypeFactory {
    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vfs/DbFileTypeFactoryBase", "createFileTypes"));
        }
        consumer.consume((FileType)new DataSourceStorageFileType(), "ids");
        consumer.consume((FileType)DbStorageFileType.SqliteStorage.INSTANCE, (String)null);
        consumer.consume((FileType)DbStorageFileType.H2Storage.INSTANCE, (String)null);
    }

    public static class DbFileTypeDetector
    implements FileTypeRegistry.FileTypeDetector {
        private final List<DbStorageFileType> myFileTypes;

        DbFileTypeDetector(FileTypeManager manager) {
            this.myFileTypes = ContainerUtil.findAll((Object[])manager.getRegisteredFileTypes(), DbStorageFileType.class);
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/vfs/DbFileTypeFactoryBase$DbFileTypeDetector", "detect"));
            }
            if (firstBytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBytes", "com/intellij/database/vfs/DbFileTypeFactoryBase$DbFileTypeDetector", "detect"));
            }
            if (firstCharsIfText != null) {
                return null;
            }
            for (DbStorageFileType fileType : this.myFileTypes) {
                String prefix = fileType.getFilePrefix();
                if (prefix.length() == 0 || firstBytes.getLength() <= prefix.length() || !prefix.equals(new String(firstBytes.getBytes(), 0, prefix.length()))) continue;
                return fileType;
            }
            return null;
        }

        public int getVersion() {
            return 1;
        }
    }
}

