/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle.tns;

import com.intellij.database.vendors.oracle.tns.OraLexer;
import com.intellij.database.vendors.oracle.tns.OraToken;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TnsNamesExtractor {
    private final OraLexer myLexer = new OraLexer();

    public static void extract(@NotNull CharSequence seq, @NotNull Consumer<String> consumer) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/database/vendors/oracle/tns/TnsNamesExtractor", "extract"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vendors/oracle/tns/TnsNamesExtractor", "extract"));
        }
        new TnsNamesExtractor().run(seq, consumer);
    }

    private TnsNamesExtractor() {
    }

    private void run(@NotNull CharSequence seq, @NotNull Consumer<String> consumer) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/database/vendors/oracle/tns/TnsNamesExtractor", "run"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vendors/oracle/tns/TnsNamesExtractor", "run"));
        }
        this.myLexer.start(seq);
        while (this.myLexer.getTokenType() != null) {
            this.consumeParameter(consumer);
        }
    }

    private static void optAdd(@NotNull List<String> list, @Nullable String s) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/vendors/oracle/tns/TnsNamesExtractor", "optAdd"));
        }
        if (s != null) {
            list.add(s);
        }
    }

    private void consumeParameter(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vendors/oracle/tns/TnsNamesExtractor", "consumeParameter"));
        }
        ArrayList aliases = ContainerUtil.newArrayList();
        TnsNamesExtractor.optAdd(aliases, this.getAlias());
        while (this.myLexer.getTokenType() == OraToken.COMMA) {
            this.myLexer.advance();
            TnsNamesExtractor.optAdd(aliases, this.getAlias());
        }
        while (this.myLexer.getTokenType() != null && this.myLexer.getTokenType() != OraToken.LPAREN && this.myLexer.getTokenType() != OraToken.LPAREN && this.myLexer.getTokenType() != OraToken.EQUALS) {
            this.myLexer.advance();
        }
        if (this.myLexer.getTokenType() == null) {
            return;
        }
        boolean tnsName = false;
        if (this.myLexer.getTokenType() == OraToken.EQUALS) {
            this.myLexer.advance();
            tnsName = true;
        }
        if (tnsName &= this.consumeBraced()) {
            for (String alias : aliases) {
                consumer.consume((Object)alias);
            }
        }
    }

    private boolean consumeBraced() {
        int braceCount = 0;
        int tokenCount = 0;
        boolean tnsName = false;
        while (this.myLexer.getTokenType() != null && (braceCount != 0 || this.myLexer.getTokenType() != OraToken.IDENTIFIER)) {
            if (tokenCount == 0) {
                tnsName = this.myLexer.getTokenType() == OraToken.LPAREN;
            } else if (tokenCount == 1) {
                tnsName &= this.myLexer.getTokenType() == OraToken.IDENTIFIER;
                tnsName &= this.myLexer.getTokenText().equalsIgnoreCase("description_list") || this.myLexer.getTokenText().equalsIgnoreCase("description");
            }
            ++tokenCount;
            if (this.myLexer.getTokenType() == OraToken.LPAREN) {
                ++braceCount;
            }
            if (this.myLexer.getTokenType() == OraToken.RPAREN) {
                --braceCount;
            }
            if (braceCount < 0) {
                braceCount = 0;
            }
            this.myLexer.advance();
        }
        return tnsName;
    }

    @Nullable
    private String getAlias() {
        if (this.myLexer.getTokenType() != OraToken.IDENTIFIER) {
            return null;
        }
        String res = this.myLexer.getTokenText();
        this.myLexer.advance();
        return res;
    }
}

