/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class SsrpEncoder {
    public static byte[] createClientBroadcastReq() {
        return new byte[]{2};
    }

    public static byte[] createClientUnicastReq() {
        return new byte[]{3};
    }

    public static byte[] createClientUnicastInstanceReq(@NotNull String instanceName) {
        if (instanceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceName", "com/intellij/database/vendors/mssql/ssrp/SsrpEncoder", "createClientUnicastInstanceReq"));
        }
        ByteBuffer buf = ByteBuffer.allocate(40);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put((byte)4);
        buf.put(Charset.defaultCharset().encode(instanceName));
        buf.put((byte)0);
        return SsrpEncoder.getWrittenBytes(buf);
    }

    public static byte[] createClientUnicastDACReq(@NotNull String instanceName) {
        if (instanceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceName", "com/intellij/database/vendors/mssql/ssrp/SsrpEncoder", "createClientUnicastDACReq"));
        }
        ByteBuffer buf = ByteBuffer.allocate(40);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put((byte)15);
        buf.put((byte)1);
        buf.put(Charset.defaultCharset().encode(instanceName));
        buf.put((byte)0);
        return SsrpEncoder.getWrittenBytes(buf);
    }

    private static byte[] getWrittenBytes(@NotNull ByteBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/database/vendors/mssql/ssrp/SsrpEncoder", "getWrittenBytes"));
        }
        byte[] res = new byte[buf.position()];
        buf = buf.slice();
        buf.get(res);
        return res;
    }
}

