/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.dataSource.inspections;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfoCache;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class DriverPortInstanceInspector
extends UrlEditorInspector {
    @Override
    protected void runInspection(@NotNull DatabaseDriver driver, @NotNull UrlEditorModel model, @NotNull UrlEditorInspector.InspectionConsumer consumer) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/vendors/mssql/dataSource/inspections/DriverPortInstanceInspector", "runInspection"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/vendors/mssql/dataSource/inspections/DriverPortInstanceInspector", "runInspection"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vendors/mssql/dataSource/inspections/DriverPortInstanceInspector", "runInspection"));
        }
        String port = model.getParameter("port");
        String instance = model.getParameter("instance");
        String host = model.getParameter("host");
        if (StringUtil.isNotEmpty((String)port) && StringUtil.isNotEmpty((String)instance) && StringUtil.isNotEmpty((String)host)) {
            String ssrpPort;
            SsrpInfo info = SsrpInfoCache.get();
            if (info == null) {
                return;
            }
            SsrpInfo.SsrpServer ssrpServer = info.getServer(host);
            SsrpInfo.SsrpInstance ssrpInstance = ssrpServer == null ? null : ssrpServer.getInstance(instance);
            String string = ssrpPort = ssrpInstance == null ? null : ssrpInstance.getAttribute("tcp");
            if (ssrpPort != null && !port.equals(ssrpPort)) {
                this.addWarning(consumer);
            }
        }
    }

    protected abstract void addWarning(@NotNull UrlEditorInspector.InspectionConsumer var1);
}

