/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptModelUtil {
    public static final Function<ScriptModel.ModelIt<?>, TextRange> TO_RANGE = it -> it.range().shiftRight((int)it.rangeOffset());
    public static final Function<ScriptModel.ModelIt<?>, String> TO_TEXT = it -> it.text();
    public static final Function<ScriptModel.ModelIt<?>, IElementType> TO_TYPE = it -> it.type();
    public static final Function<ScriptModel.ModelIt<?>, Object> TO_OBJECT = it -> it.object();
    public static final Function<ScriptModel.ParamIt<?>, String> TO_NAME = it -> it.name();

    private ScriptModelUtil() {
    }

    @NotNull
    public static Condition<TextRange> INTERSECTS_RANGE(TextRange range) {
        Condition condition = r -> {
            int e;
            int s = Math.max(r.getStartOffset(), range.getStartOffset());
            if (s == (e = Math.min(r.getEndOffset(), range.getEndOffset()))) {
                return s == r.getEndOffset() || range.getLength() == 0;
            }
            return s < e;
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "INTERSECTS_RANGE"));
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> CONTAINS_RANGE(TextRange range) {
        Condition condition = r -> r.equals((Object)range) || r.contains(range);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "CONTAINS_RANGE"));
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> IN_RANGE(TextRange range) {
        Condition condition = r -> range.contains(r);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "IN_RANGE"));
        }
        return condition;
    }

    @NotNull
    public static Condition<ScriptModel.ModelIt<?>> AT_OFFSET2(int offset) {
        Condition condition = o -> o.range().contains(offset);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "AT_OFFSET2"));
        }
        return condition;
    }

    @NotNull
    public static <V> Function<SyntaxTraverser<V>, SyntaxTraverser<V>> LIMIT_TO_RANGE(final TextRange range) {
        Function.Mono mono = new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> vs) {
                return ScriptModelUtil.inRange(vs, range);
            }
        };
        if (mono == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "LIMIT_TO_RANGE"));
        }
        return mono;
    }

    @NotNull
    public static <T> ScriptModel<T> adjustModelForSelection(@NotNull ScriptModel<T> model, @NotNull Document document, @NotNull TextRange selectionRange) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/script/ScriptModelUtil", "adjustModelForSelection"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/script/ScriptModelUtil", "adjustModelForSelection"));
        }
        if (selectionRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionRange", "com/intellij/database/script/ScriptModelUtil", "adjustModelForSelection"));
        }
        TextRange adjustedRange = ScriptModelUtil.adjustSelectionRange(model, document, selectionRange);
        int fixedOffset = adjustedRange.contains(selectionRange.getStartOffset()) ? selectionRange.getStartOffset() : adjustedRange.getStartOffset();
        ScriptModel scriptModel = selectionRange.getLength() == 0 ? model.subModel(TextRange.from((int)fixedOffset, (int)0), true) : model.subModel(adjustedRange, false);
        if (scriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "adjustModelForSelection"));
        }
        return scriptModel;
    }

    @NotNull
    public static TextRange getSelectedStatementsRange(@NotNull AbstractQueryLanguageConsole console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/script/ScriptModelUtil", "getSelectedStatementsRange"));
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)console.getLanguageConsole().getCurrentEditor());
        TextRange textRange = ScriptModelUtil.adjustSelectionRange(console.getScriptModel(), console.getLanguageConsole().getEditorDocument(), range);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "getSelectedStatementsRange"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getSelectionForConsole(@Nullable Editor editor) {
        if (editor == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "getSelectionForConsole"));
            }
            return textRange;
        }
        if (DatabaseSettings.getSettings().executeSelectionOption == 3) {
            TextRange textRange = EditorUtil.getSelectionInAnyMode((Editor)editor);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "getSelectionForConsole"));
            }
            return textRange;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        TextRange textRange = TextRange.create((int)caret.getSelectionStart(), (int)caret.getSelectionEnd());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "getSelectionForConsole"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange adjustSelectionRange(@NotNull ScriptModel<?> model, @NotNull Document document, @NotNull TextRange selectionRange) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
        }
        if (selectionRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionRange", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
        }
        DatabaseSettings settings = DatabaseSettings.getSettings();
        if (selectionRange.isEmpty()) {
            TextRange subRange;
            TextRange r;
            int lineEnd;
            int lineNumber;
            int lineStart;
            int lineStartFixed;
            CharSequence sequence = document.getCharsSequence();
            int sequenceLength = sequence.length();
            if (sequenceLength == 0) {
                TextRange textRange = selectionRange;
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
                }
                return textRange;
            }
            int offset = Math.min(sequenceLength - 1, selectionRange.getStartOffset());
            if (!Character.isWhitespace(sequence.charAt(offset))) {
                ++offset;
            }
            if ((lineStartFixed = EditorActionUtil.findFirstNonSpaceOffsetInRange((CharSequence)sequence, (int)(lineStart = document.getLineStartOffset(lineNumber = document.getLineNumber(offset))), (int)(lineEnd = document.getLineEndOffset(lineNumber)))) >= 0 && (r = (TextRange)model.subModel(subRange = TextRange.create((int)lineStartFixed, (int)(lineStartFixed < offset ? offset : lineStartFixed)), true).statements().filter(Conditions.compose(TO_OBJECT, (Condition)Conditions.instanceOf(SqlStatement.class))).transform(TO_RANGE).last()) != null) {
                TextRange textRange = r;
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
                }
                return textRange;
            }
        } else {
            if (settings.executeSelectionOption != 3) {
                TextRange textRange = selectionRange;
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
                }
                return textRange;
            }
            ScriptModel m = model.subModel(selectionRange, false);
            if (m.statements().take(2).size() > 1) {
                TextRange r = selectionRange;
                for (TextRange range : m.statements().transform(TO_RANGE)) {
                    r = r.union(range);
                }
                TextRange textRange = r;
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
                }
                return textRange;
            }
        }
        TextRange textRange = selectionRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "adjustSelectionRange"));
        }
        return textRange;
    }

    @NotNull
    public static <V> SyntaxTraverser<V> inRange(@NotNull SyntaxTraverser<V> s, @NotNull TextRange range) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/script/ScriptModelUtil", "inRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/script/ScriptModelUtil", "inRange"));
        }
        TextRange adjusted = range.shiftRight(-ScriptModelUtil.getPartOffsetAsInt(s));
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)s.expandAndFilter(Conditions.compose((Function)s.api.TO_RANGE, ScriptModelUtil.INTERSECTS_RANGE(adjusted)));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "inRange"));
        }
        return syntaxTraverser;
    }

    public static int getPartOffsetAsInt(SyntaxTraverser<?> s) {
        return (int)ScriptModelUtil.getPartOffset(s);
    }

    public static long getPartOffset(SyntaxTraverser<?> s) {
        Long o = (Long)s.getUserData(SqlReader.PART_OFFSET);
        return o == null ? 0L : o;
    }

    public static <V> String statementText(ScriptModel.StatementIt<V> st, ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<V>> paramCondition) {
        JBIterable params2 = st.parameters().filter(Conditions.not(paramCondition));
        String text = st.text();
        StringBuilder sb = null;
        int offset = st.range().getStartOffset();
        int curIndex = 0;
        for (ScriptModel.ParamIt it : params2) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            TextRange r = it.range();
            Object v = storage.getValue((Object)it.name());
            if (v == null) {
                sb.append(text, curIndex, r.getEndOffset() - offset);
            } else {
                sb.append(text, curIndex, r.getStartOffset() - offset);
                sb.append(v);
            }
            curIndex = r.getEndOffset() - offset;
        }
        return sb == null ? text : sb.append(text, curIndex, text.length()).toString();
    }

    @NotNull
    public static <V> Iterable<String> getRelativeSnippet(V current, SyntaxTraverser.Api<V> api) {
        Object parent = api.parent(current);
        if (parent == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "getRelativeSnippet"));
            }
            return jBIterable;
        }
        TextRange pr = api.rangeOf(parent);
        TextRange cr = api.rangeOf(current);
        int delta = 15;
        int a2 = cr.getStartOffset() - pr.getStartOffset();
        int b2 = cr.getEndOffset() - pr.getStartOffset();
        int s = Math.max(a2 - delta, 0);
        int e = Math.min(b2 + delta, pr.getLength());
        int a1 = s < delta ? 0 : s;
        int b1 = pr.getLength() - e < delta ? pr.getLength() : e;
        CharSequence t = api.textOf(parent);
        JBIterable jBIterable = JBIterable.of((Object[])new String[]{(a1 > 0 ? "..." : "") + t.subSequence(a1, a2), t.subSequence(a2, b2).toString(), t.subSequence(b2, b1) + (b1 < pr.getLength() ? "..." : "")});
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "getRelativeSnippet"));
        }
        return jBIterable;
    }

    @NotNull
    public static <V> Condition<V> wholeFileCondition(SyntaxTraverser<V> s, boolean leavesOnly, Class<? extends V> statementClass) {
        Condition condition = v -> {
            if (!(s.api.typeOf(v) instanceof IFileElementType)) {
                return false;
            }
            JBIterable it = ((SyntaxTraverser)((SyntaxTraverser)s.withRoot(v)).reset()).preOrderDfsTraversal().skip(1);
            Object st = it.filter(Conditions.instanceOf((Class)statementClass)).first();
            if (st == null) {
                return s.api.rangeOf(v).getLength() > 256 || !StringUtil.isEmptyOrSpaces((CharSequence)s.api.textOf(v));
            }
            if (leavesOnly) {
                if (DatabaseSettings.getSettings().executeSelectionOption == 1) {
                    return !Comparing.equal((Object)s.api.rangeOf(v), (Object)s.api.rangeOf(st));
                }
                return s.api.rangeOf(st).getStartOffset() > 0 && !it.takeWhile(Conditions.notEqualTo((Object)st)).filter(Conditions.notInstanceOf(PsiComment.class)).isEmpty();
            }
            return ((SyntaxTraverser)s.withRoot(v)).preOrderDfsTraversal().take(3).size() > 2;
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModelUtil", "wholeFileCondition"));
        }
        return condition;
    }

    public static class ParamHelper
    extends DocumentAdapter {
        private static final Key<ParamHelper> PARAM_NAMES = Key.create((String)"PARAM_NAMES");
        private final AtomicInteger counter = new AtomicInteger();
        private final ConcurrentMap<Segment, String> map = ContainerUtil.newConcurrentMap();

        private ParamHelper() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            if (this.map.size() < 100) {
                return;
            }
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                if (((RangeMarker)it.next()).isValid()) continue;
                it.remove();
            }
        }

        @Nullable
        public static String getParameterId(@NotNull ScriptModel.ParamIt<?> it, String baseName, @Nullable UserDataHolder userDataHolder) {
            TextRange segment;
            if (it == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/database/script/ScriptModelUtil$ParamHelper", "getParameterId"));
            }
            if (userDataHolder == null) {
                return null;
            }
            ParamHelper names = (ParamHelper)((Object)PARAM_NAMES.get(userDataHolder));
            if (names == null) {
                names = new ParamHelper();
                PARAM_NAMES.set(userDataHolder, (Object)names);
                if (userDataHolder instanceof Document) {
                    ((Document)userDataHolder).addDocumentListener((DocumentListener)names);
                }
            }
            TextRange r = it.range().shiftRight((int)it.rangeOffset());
            if (userDataHolder instanceof DocumentEx) {
                DocumentEx document = (DocumentEx)userDataHolder;
                Ref found = Ref.create();
                document.processRangeMarkersOverlappingWith(r.getStartOffset(), r.getEndOffset(), marker -> {
                    if (!r.equalsToRange(marker.getStartOffset(), marker.getEndOffset())) {
                        return true;
                    }
                    if (marker.isGreedyToLeft() || baseName == null && marker.isGreedyToRight()) {
                        return true;
                    }
                    found.set(marker);
                    return false;
                });
                RangeMarker marker2 = (RangeMarker)found.get();
                if (marker2 == null || !marker2.isValid()) {
                    marker2 = document.createRangeMarker(r);
                    if (baseName != null) {
                        marker2.setGreedyToRight(true);
                    }
                }
                segment = marker2;
            } else {
                segment = r;
            }
            String name = (String)names.map.get(segment);
            return name != null ? name : (String)ConcurrencyUtil.cacheOrGet(names.map, (Object)segment, (Object)(baseName != null ? baseName : "#" + names.counter.incrementAndGet()));
        }
    }
}

