/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.postgres;

import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.TruncateTableOperation;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgTruncateTableOperation
extends TruncateTableOperation {
    public PgTruncateTableOperation() {
        super(RESTART_SEQUENCES, CASCADE, USE_DELETE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/postgres/PgTruncateTableOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/postgres/PgTruncateTableOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/postgres/PgTruncateTableOperation", "generate"));
        }
        Iterable values = (Iterable)OPTION_VALUES.get(data);
        if (PgTruncateTableOperation.findOption(values, USE_DELETE) == Boolean.TRUE) {
            DdlBuilder ddlBuilder = super.generate(builder, object, data, context);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/postgres/PgTruncateTableOperation", "generate"));
            }
            return ddlBuilder;
        }
        Boolean restartSeq = (Boolean)PgTruncateTableOperation.findOption(values, RESTART_SEQUENCES);
        Boolean cascade = (Boolean)PgTruncateTableOperation.findOption(values, CASCADE);
        builder.keywords("TRUNCATE", "TABLE").space().qualifiedRef(object);
        if (restartSeq != null) {
            builder.newLine().tab().keywords(restartSeq != false ? "RESTART" : "CONTINUE", "IDENTITY");
        }
        if (cascade != null) {
            builder.newLine().tab().keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        DdlBuilder ddlBuilder = builder.newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/postgres/PgTruncateTableOperation", "generate"));
        }
        return ddlBuilder;
    }
}

