/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.db2;

import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.TruncateTableOperation;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2TruncateTableOperation
extends TruncateTableOperation {
    public Db2TruncateTableOperation() {
        super(DROP_STORAGE, IGNORE_DELETE_TRIGGERS, IMMEDIATE, USE_DELETE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/db2/Db2TruncateTableOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/db2/Db2TruncateTableOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/db2/Db2TruncateTableOperation", "generate"));
        }
        Iterable values = (Iterable)OPTION_VALUES.get(data);
        if (Db2TruncateTableOperation.findOption(values, USE_DELETE) == Boolean.TRUE) {
            DdlBuilder ddlBuilder = super.generate(builder, object, data, context);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/db2/Db2TruncateTableOperation", "generate"));
            }
            return ddlBuilder;
        }
        Boolean dropStorage = (Boolean)Db2TruncateTableOperation.findOption(values, DROP_STORAGE);
        Boolean ignoreDT = (Boolean)Db2TruncateTableOperation.findOption(values, IGNORE_DELETE_TRIGGERS);
        Boolean immediate = (Boolean)Db2TruncateTableOperation.findOption(values, IMMEDIATE);
        builder.keywords("TRUNCATE", "TABLE").space().qualifiedRef(object);
        if (dropStorage != null) {
            builder.newLine().tab().keywords(dropStorage != false ? "DROP" : "REUSE", "STORAGE");
        }
        if (ignoreDT != null) {
            builder.newLine().tab().keywords(ignoreDT != false ? "IGNORE" : "RESTRICT WHEN", "DELETE", "TRIGGERS");
        }
        if (immediate == Boolean.TRUE) {
            builder.newLine().tab().keyword("IMMEDIATE");
        }
        DdlBuilder ddlBuilder = builder.newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/db2/Db2TruncateTableOperation", "generate"));
        }
        return ddlBuilder;
    }
}

