/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeNamespace
extends DeObject
implements DasNamespace {
    @NotNull
    public ObjectKind kind;
    public final Set<DeObject> children;
    @Nullable
    public DeNamespace parent;

    protected DeNamespace(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeNamespace", "<init>"));
        }
        super(model);
        this.kind = ObjectKind.NONE;
        this.children = ContainerUtil.newHashSet();
    }

    @Override
    public void copyChildrenFrom(@NotNull DeObject obj, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeNamespace", "copyChildrenFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeNamespace", "copyChildrenFrom"));
        }
        super.copyChildrenFrom(obj, copier);
        DeNamespace namespace = (DeNamespace)obj;
        this.children.clear();
        for (DeObject child : namespace.children) {
            this.children.add(copier.copy(child, true));
        }
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeNamespace", "copyFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeNamespace", "copyFrom"));
        }
        super.copyFrom(obj, withChildren, copier);
        DeNamespace namespace = (DeNamespace)obj;
        this.parent = copier.copy(namespace.parent, false);
        this.kind = namespace.kind;
        DeNamespace deNamespace = this;
        if (deNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeNamespace", "copyFrom"));
        }
        return deNamespace;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeNamespace", "emptyClone"));
        }
        DeNamespace deNamespace = new DeNamespace(model);
        if (deNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeNamespace", "emptyClone"));
        }
        return deNamespace;
    }

    public DeNamespace(@NotNull String name, @NotNull ObjectKind kind, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/model/DeNamespace", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/schemaEditor/model/DeNamespace", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeNamespace", "<init>"));
        }
        super(name, model);
        this.kind = ObjectKind.NONE;
        this.children = ContainerUtil.newHashSet();
        this.kind = kind;
    }

    @Override
    @NotNull
    public JBIterable<DeObject> getChildren() {
        JBIterable jBIterable = JBIterable.from(this.children);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeNamespace", "getChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public DeObject getParent() {
        return this.parent;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.kind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeNamespace", "getKind"));
        }
        return objectKind;
    }
}

