/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeColumnListBase
extends DeTableChild {
    protected DeColumnListBase(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeColumnListBase", "<init>"));
        }
        super(model);
    }

    public DeColumnListBase(@NotNull String name, @NotNull DeTable table, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/model/DeColumnListBase", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/model/DeColumnListBase", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeColumnListBase", "<init>"));
        }
        super(name, table, model);
    }

    @NotNull
    public abstract Iterable<DeColumn> getColumns();

    @NotNull
    public MultiRef<? extends DasTypedObject> getColumnsRef() {
        MultiRef multiRef = DasUtil.asRef(this.getColumns());
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeColumnListBase", "getColumnsRef"));
        }
        return multiRef;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/model/DeColumnListBase", "isAlteredIgnoringChild"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/schemaEditor/model/DeColumnListBase", "isAlteredIgnoringChild"));
        }
        if (otherChildren == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherChildren", "com/intellij/database/schemaEditor/model/DeColumnListBase", "isAlteredIgnoringChild"));
        }
        return DeColumnListBase.isObjectsIdentityAltered(this.getColumns(), ((DeColumnListBase)other).getColumns()) || super.isAlteredIgnoringChild(other, children, otherChildren);
    }

    @Nullable
    protected static <T extends DeObject> T nullize(@Nullable T a) {
        return a == null || EditorModelUtil.isStub(a) && StringUtil.isEmpty((String)a.name) ? null : (T)a;
    }

    protected static boolean isObjectIdentityAltered(@Nullable DeObject a, @Nullable DeObject b) {
        a = DeColumnListBase.nullize(a);
        b = DeColumnListBase.nullize(b);
        if (a == null || b == null) {
            return a != b;
        }
        if (EditorModelUtil.isStub(a) && EditorModelUtil.isStub(b)) {
            return a.isAltered(b);
        }
        return a.editedObject != b && b.editedObject != a;
    }

    protected static boolean isObjectsIdentityAltered(@NotNull Iterable<? extends DeObject> a, @NotNull Iterable<? extends DeObject> b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/database/schemaEditor/model/DeColumnListBase", "isObjectsIdentityAltered"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/schemaEditor/model/DeColumnListBase", "isObjectsIdentityAltered"));
        }
        Iterator<? extends DeObject> ait = a.iterator();
        Iterator<? extends DeObject> bit = b.iterator();
        while (ait.hasNext() && bit.hasNext()) {
            if (!DeColumnListBase.isObjectIdentityAltered(ait.next(), bit.next())) continue;
            return true;
        }
        return ait.hasNext() != bit.hasNext();
    }
}

