/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.fix;

import com.intellij.database.schemaEditor.fix.DdlGraphFixing;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixCyclicCreateTableFk
implements DdlGraphFixing.CycleFixer {
    @Override
    public boolean fixCycle(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DdlGraph graph, @NotNull List<DdlOperationKey> cycle) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "fixCycle"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "fixCycle"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "fixCycle"));
        }
        if (cycle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycle", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "fixCycle"));
        }
        for (int i2 = 0; i2 < cycle.size(); ++i2) {
            if (!FixCyclicCreateTableFk.processItem(generator, builder, cycle, i2)) continue;
            return true;
        }
        return false;
    }

    private static boolean processItem(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull List<DdlOperationKey> cycle, int idx) {
        Set keys;
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "processItem"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "processItem"));
        }
        if (cycle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycle", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "processItem"));
        }
        DdlOperationKey current = cycle.get(idx);
        DdlOperationKey next = cycle.get((idx + 1) % cycle.size());
        if (current.operation != DasDdlOperations.CREATE_TABLE || next.operation != DasDdlOperations.CREATE_TABLE) {
            return false;
        }
        UserDataHolder data = builder.getData(current);
        JBIterable<DeForeignKey> toFix = FixCyclicCreateTableFk.getKeysToFix((DeTable)current.target, (DeTable)next.target, data);
        if (toFix.isEmpty()) {
            return false;
        }
        generator.removeOperation(builder, current.operation, current.target, data);
        if (data == null) {
            data = builder.newData(null);
        }
        if ((keys = (Set)DasDdlOperations.CreateTableOperation.DEFERRED_FKS.get(data)) == null) {
            keys = ContainerUtil.newHashSet();
            DasDdlOperations.CreateTableOperation.DEFERRED_FKS.set(data, (Object)keys);
        }
        for (DeForeignKey key : toFix) {
            keys.add(key);
        }
        generator.addOperation(builder, current.operation, current.target, data);
        return true;
    }

    private static JBIterable<DeForeignKey> getKeysToFix(@NotNull DeTable table, @NotNull DeTable target, @Nullable UserDataHolder data) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "getKeysToFix"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "getKeysToFix"));
        }
        Set<DeForeignKey> keys = DasDdlOperations.CreateTableOperation.getDeferredFks(data);
        return JBIterable.from(table.foreignKeys).filter(key -> {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk", "lambda$getKeysToFix$0"));
            }
            return key.target == target && !keys.contains(key);
        });
    }
}

