/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.selection;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.util.DbImplUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.OptionalInt;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSelectionTracker {
    private final Stack<ModelIndex<DataConsumer.Row>> myRows;
    private final DataGrid myGrid;
    private boolean myAdjusting;

    public GridSelectionTracker(@NotNull DataGrid grid, @NotNull TableResultView view2) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "<init>"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "<init>"));
        }
        this.myGrid = grid;
        this.myRows = ContainerUtil.newStack();
        view2.getColumnModel().getSelectionModel().addListSelectionListener(this::selectionChanged);
        view2.getSelectionModel().addListSelectionListener(this::selectionChanged);
    }

    public void performOperation(@NotNull Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "performOperation"));
        }
        if (!this.checkAndFillStack(operation)) {
            return;
        }
        operation.perform(this);
        this.updateSelection();
    }

    public boolean canPerformOperation(@NotNull Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "canPerformOperation"));
        }
        SelectionModel model = this.myGrid.getSelectionModel();
        return operation.checkStackSize(this.myRows.size()) || operation.checkSelectedRowsCount(model.getSelectedRowCount()) && operation.checkSelectedColumnsCount(model.getSelectedColumnCount()) && this.\u0441heckRowEquality();
    }

    private boolean checkAndFillStack(@NotNull Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "checkAndFillStack"));
        }
        if (!this.canPerformOperation(operation)) {
            return false;
        }
        if (this.myRows.isEmpty()) {
            this.myRows.addAll(this.myGrid.getSelectionModel().getSelectedRows().asList());
        }
        return true;
    }

    private void updateSelection() {
        this.run(() -> this.myGrid.getSelectionModel().setRowSelection(this.getRows()));
    }

    @NotNull
    private ModelIndexSet<DataConsumer.Row> getRows() {
        int[] rows = this.myRows.stream().filter(idx -> idx.isValid(this.myGrid)).mapToInt(Index::asInteger).toArray();
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myGrid, rows);
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "getRows"));
        }
        return modelIndexSet;
    }

    @Nullable
    private ModelIndex<DataConsumer.Row> findNext(@NotNull ViewIndex<DataConsumer.Row> stopRow) {
        if (stopRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopRow", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "findNext"));
        }
        ViewIndex<DataConsumer.Row> startRow = this.getLastRow();
        SelectionModel model = this.myGrid.getSelectionModel();
        ViewIndex<DataConsumer.Row> next = ViewIndex.forRow(this.myGrid, this.next(startRow.asInteger()));
        ModelIndex<DataConsumer.Row> startRowModelIdx = startRow.toModel(this.myGrid);
        while (next.asInteger() != startRow.asInteger()) {
            if (stopRow.asInteger() == next.asInteger()) {
                return null;
            }
            ModelIndex<DataConsumer.Row> nextModelIdx = next.toModel(this.myGrid);
            boolean isValid = next.isValid(this.myGrid);
            boolean isNotSelectedRow = !model.isSelectedRow(nextModelIdx);
            boolean isNotInStack = !this.myRows.contains(nextModelIdx);
            boolean valuesAreEqual = this.rowEquals(startRowModelIdx, nextModelIdx);
            if (isNotInStack && isValid && isNotSelectedRow && valuesAreEqual) {
                return nextModelIdx;
            }
            next = ViewIndex.forRow(this.myGrid, this.next(next.asInteger()));
        }
        return null;
    }

    @NotNull
    private ViewIndex<DataConsumer.Row> getLastRow() {
        if (!this.myRows.isEmpty()) {
            ViewIndex<DataConsumer.Row> viewIndex = ((ModelIndex)this.myRows.peek()).toView(this.myGrid);
            if (viewIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "getLastRow"));
            }
            return viewIndex;
        }
        SelectionModel model = this.myGrid.getSelectionModel();
        ViewIndexSet rows = model.getSelectedRows().toView(this.myGrid);
        OptionalInt max = rows.asList().stream().mapToInt(Index::asInteger).max();
        if (!max.isPresent()) {
            ViewIndex<DataConsumer.Row> viewIndex = ViewIndex.forRow(this.myGrid, 0);
            if (viewIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "getLastRow"));
            }
            return viewIndex;
        }
        ViewIndex<DataConsumer.Row> viewIndex = ViewIndex.forRow(this.myGrid, max.getAsInt());
        if (viewIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "getLastRow"));
        }
        return viewIndex;
    }

    private boolean \u0441heckRowEquality() {
        SelectionModel selectionModel = this.myGrid.getSelectionModel();
        ModelIndexSet rows = selectionModel.getSelectedRows();
        ModelIndex previous = (ModelIndex)rows.first();
        ArrayList rowsList = ContainerUtil.newArrayList();
        for (ModelIndex rowIdx : rows.asIterable()) {
            if (!this.rowEquals(rowIdx, previous)) {
                return false;
            }
            rowsList.add(rowIdx);
        }
        return true;
    }

    private boolean rowEquals(@NotNull ModelIndex<DataConsumer.Row> first, @NotNull ModelIndex<DataConsumer.Row> second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "rowEquals"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "rowEquals"));
        }
        GridModel model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        SelectionModel selectionModel = this.myGrid.getSelectionModel();
        ModelIndexSet columns = selectionModel.getSelectedColumns();
        for (ModelIndex colIdx : columns.asIterable()) {
            if (DbImplUtil.valuesEqual(model.getValueAt(first, colIdx), model.getValueAt(second, colIdx))) continue;
            return false;
        }
        return true;
    }

    private int next(int current) {
        return ++current >= this.myGrid.getVisibleRowsCount() ? 0 : current;
    }

    private void selectionChanged(ListSelectionEvent e) {
        if (this.myAdjusting) {
            return;
        }
        this.myRows.clear();
    }

    private void run(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker", "run"));
        }
        this.myAdjusting = true;
        try {
            runnable.run();
        }
        finally {
            this.myAdjusting = false;
        }
    }

    public static enum Operation {
        SELECT_NEXT(1, 1, 1){

            @Override
            boolean perform(@NotNull GridSelectionTracker tracker) {
                if (tracker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker$Operation$1", "perform"));
                }
                ModelIndex next = tracker.findNext(tracker.getLastRow());
                if (next == null) {
                    return false;
                }
                tracker.myRows.add((Object)next);
                return true;
            }
        }
        ,
        SELECT_ALL(1, 1, 1){

            @Override
            boolean perform(@NotNull GridSelectionTracker tracker) {
                ModelIndex next;
                if (tracker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker$Operation$2", "perform"));
                }
                int rowCount = tracker.myRows.size();
                ViewIndex row = tracker.getLastRow();
                while ((next = tracker.findNext(row)) != null) {
                    tracker.myRows.add((Object)next);
                }
                return rowCount != tracker.myRows.size();
            }
        }
        ,
        UNSELECT_PREVIOUS(2, 1, 2){

            @Override
            boolean perform(@NotNull GridSelectionTracker tracker) {
                if (tracker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker$Operation$3", "perform"));
                }
                tracker.myRows.pop();
                return true;
            }
        };

        private final int myMinStackSize;
        private final int myMinSelectedColumns;
        private final int myMinSelectedRows;

        private Operation(int minStackSize, int minSelectedColumns, int minSelectedRows) {
            this.myMinStackSize = minStackSize;
            this.myMinSelectedColumns = minSelectedColumns;
            this.myMinSelectedRows = minSelectedRows;
        }

        boolean checkStackSize(int size) {
            return size >= this.myMinStackSize;
        }

        boolean checkSelectedColumnsCount(int count) {
            return count >= this.myMinSelectedColumns;
        }

        boolean checkSelectedRowsCount(int count) {
            return count >= this.myMinSelectedRows;
        }

        abstract boolean perform(@NotNull GridSelectionTracker var1);
    }
}

