/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import org.jetbrains.annotations.NotNull;

public class ZonedTimestampDelegate
extends DateAndTimeFormatterDelegate<TimeZonedTimestamp, ZonedDateTime> {
    public ZonedTimestampDelegate() {
        super(ZonedDateTime::from, temporal -> LocalDateTime.from(temporal).atZone(ZoneId.systemDefault()), temporal -> LocalDate.from(temporal).atTime(0, 0, 0).atZone(ZoneId.systemDefault()));
    }

    @Override
    protected ZonedDateTime toTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/ZonedTimestampDelegate", "toTemporalAccessor"));
        }
        if (!(value instanceof TimeZonedTimestamp)) {
            throw new IllegalArgumentException("Value must be type of TimeZonedTimestamp");
        }
        TimeZonedTimestamp zonedTimestamp = (TimeZonedTimestamp)value;
        Timestamp timestamp = (Timestamp)zonedTimestamp.getValue();
        ZoneId zoneId = zonedTimestamp.getZoneOffset() == null ? ZoneId.systemDefault() : zonedTimestamp.getZoneOffset();
        int era = DataGridFormattersUtil.getEra(timestamp, zoneId);
        return timestamp.toLocalDateTime().atZone(zoneId).with(ChronoField.ERA, era);
    }

    @Override
    protected TimeZonedTimestamp create(@NotNull ZonedDateTime value, @NotNull String stringRepresentation) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/ZonedTimestampDelegate", "create"));
        }
        if (stringRepresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/run/ui/grid/editors/ZonedTimestampDelegate", "create"));
        }
        return new TimeZonedTimestamp(Timestamp.valueOf(value.toLocalDateTime()), stringRepresentation);
    }
}

