/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ShortZonedTimestampDelegate
extends DateAndTimeFormatterDelegate<TimeZonedTimestamp, TemporalAccessor> {
    public ShortZonedTimestampDelegate() {
        super(LocalDateTime::from, temporal -> LocalDate.from(temporal).atTime(0, 0, 0));
    }

    @Override
    protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/ShortZonedTimestampDelegate", "toTemporalAccessor"));
        }
        if (!(value instanceof TimeZonedTimestamp)) {
            throw new IllegalArgumentException("Value must be of type TimeZonedTimestamp");
        }
        TimeZonedTimestamp zonedTimestamp = (TimeZonedTimestamp)value;
        Timestamp timestamp = (Timestamp)zonedTimestamp.getValue();
        ZoneOffset now = ZonedDateTime.now().getOffset();
        ZoneOffset zoneId = zonedTimestamp.getZoneOffset() == null ? now : zonedTimestamp.getZoneOffset();
        LocalDateTime localDateTime = timestamp.toLocalDateTime();
        LocalDateTime temporal = Objects.equals(zoneId, now) ? localDateTime : localDateTime.atZone(zoneId);
        return temporal.with(ChronoField.ERA, DataGridFormattersUtil.getEra(timestamp, zoneId));
    }

    @Override
    protected TimeZonedTimestamp create(@NotNull TemporalAccessor value, @NotNull String stringRepresentation) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/ShortZonedTimestampDelegate", "create"));
        }
        if (stringRepresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/run/ui/grid/editors/ShortZonedTimestampDelegate", "create"));
        }
        return new TimeZonedTimestamp(Timestamp.valueOf(LocalDateTime.from(value)), stringRepresentation);
    }
}

