/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.ui.basic.BasicCalendarPaneUI;
import com.michaelbaranov.microba.calendar.ui.basic.CalendarGridPanel;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.sql.Date;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultDateEditorFactory
extends FormatBasedGridCellEditorFactory {
    DefaultDateEditorFactory() {
    }

    @Override
    @NotNull
    protected Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        Formatter formatter = grid.getObjectFormatter().getDateFormat(c, dialect);
        if (formatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getFormat"));
        }
        return formatter;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        return ExtractorsUtil.guessJdbcType(c) == 91 ? 1 : 0;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, final @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor.WithBrowseButton<CalendarPane> withBrowseButton = new FormatBasedGridCellEditor.WithBrowseButton<CalendarPane>(project, grid, format, value, nullValue, initiator, column){

            @Override
            @Nullable
            public Object getValue() {
                Object v = super.getValue();
                return v instanceof java.util.Date ? new Date(((java.util.Date)v).getTime()) : v;
            }

            @Override
            protected Object createObject(@NotNull Long internalValue) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1", "createObject"));
                }
                return new Date(internalValue);
            }

            @Override
            protected void configurePopup(@NotNull JBPopup popup, @NotNull CalendarPane component) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1", "configurePopup"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1", "configurePopup"));
                }
                component.addActionListener(e -> {
                    if (popup == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1", "lambda$configurePopup$1"));
                    }
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1", "lambda$configurePopup$1"));
                    }
                    if (popup.isDisposed()) {
                        return;
                    }
                    java.util.Date date = component.getDate() == null ? new java.util.Date() : component.getDate();
                    this.processDate(date.getTime(), () -> {
                        if (popup == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1", "lambda$null$0"));
                        }
                        popup.closeOk(null);
                    }, () -> component.requestFocus());
                });
            }

            @Override
            @NotNull
            protected Pair<CalendarPane, JComponent> getPopupComponents() {
                Object value = this.getValue();
                java.util.Date initialDate = value instanceof java.util.Date ? DataGridFormattersUtil.getBoundedValue(value, column, grid) : new java.util.Date();
                MyCalendarPane calendarPane = new MyCalendarPane(initialDate, this.getNullValue() != null);
                Pair pair = Pair.create((Object)((Object)calendarPane), (Object)((Object)calendarPane));
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory$1", "getPopupComponents"));
                }
                return pair;
            }
        };
        if (withBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultDateEditorFactory", "createEditorImpl"));
        }
        return withBrowseButton;
    }

    private static class MyCalendarPane
    extends CalendarPane {
        private boolean mySettingDate;

        public MyCalendarPane(java.util.Date initialDate, boolean showNoneButton) {
            super(initialDate);
            this.setFocusLostBehavior(3);
            this.setShowNoneButton(showNoneButton);
            this.setShowNumberOfWeek(true);
            this.setShowTodayButton(true);
            this.setStripTime(false);
        }

        public void updateUI() {
            this.setUI((ComponentUI)new BasicCalendarPaneUI(){

                protected void createNestedComponents() {
                    super.createNestedComponents();
                    CalendarGridPanel gridComponent = this.gridPanel;
                    ActionMap actionMap = gridComponent.getActionMap();
                    actionMap.put("##microba.commit##", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                this.commit();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.invalidate();
        }

        public void setDate(java.util.Date date) throws PropertyVetoException {
            if (this.mySettingDate) {
                super.setDate(date);
            } else {
                this.doSetDate(date);
            }
        }

        private void doSetDate(java.util.Date date) throws PropertyVetoException {
            this.mySettingDate = true;
            try {
                boolean dateChanged = !Comparing.equal((Object)date, (Object)this.getDate());
                super.setDate(date);
                if (!dateChanged) {
                    this.fireActionEvent();
                }
            }
            finally {
                this.mySettingDate = false;
            }
        }
    }
}

