/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CellEditorScratchRootType
extends RootType {
    private static final String FILENAME = "cell";
    private static final Key<Language> LANGUAGE_DATA_KEY = Key.create((String)"SubstituteLanguage");

    CellEditorScratchRootType() {
        super("consoles/.datagrid", null);
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/CellEditorScratchRootType", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/ui/grid/editors/CellEditorScratchRootType", "substituteLanguage"));
        }
        return (Language)LANGUAGE_DATA_KEY.get((UserDataHolder)file);
    }

    public static VirtualFile newScratch(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/CellEditorScratchRootType", "newScratch"));
        }
        VirtualFile file = ((CellEditorScratchRootType)RootType.findByClass(CellEditorScratchRootType.class)).findFile(project, FILENAME, ScratchFileService.Option.create_new_always);
        if (file != null) {
            TrailingSpacesStripper.setEnabled((VirtualFile)file, (boolean)false);
        }
        return file;
    }

    public static void setLanguage(@NotNull Project project, @NotNull VirtualFile file, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/CellEditorScratchRootType", "setLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/ui/grid/editors/CellEditorScratchRootType", "setLanguage"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/grid/editors/CellEditorScratchRootType", "setLanguage"));
        }
        assert (ScratchFileService.getInstance().getRootType(file) instanceof CellEditorScratchRootType);
        LANGUAGE_DATA_KEY.set((UserDataHolder)file, (Object)language);
        PsiDocumentManager.getInstance((Project)project).reparseFiles(Collections.singletonList(file), false);
    }
}

