/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import java.sql.Time;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractZonedTimeDelegate
extends DateAndTimeFormatterDelegate<TimeZonedTime, TemporalAccessor> {
    private static final String ERROR_MESSAGE = "Offset out of range (from -12:00 to +14:00)";
    private static final ZoneOffset MAX_ZONE_OFFSET = ZoneOffset.of("+14:00");
    private static final ZoneOffset MIN_ZONE_OFFSET = ZoneOffset.of("-12:00");

    public AbstractZonedTimeDelegate() {
        super(AbstractZonedTimeDelegate::extractOffsetTime, AbstractZonedTimeDelegate::extractWithLocalOffset);
    }

    @Override
    protected TimeZonedTime create(@NotNull TemporalAccessor value, @NotNull String stringRepresentation) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/AbstractZonedTimeDelegate", "create"));
        }
        if (stringRepresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/run/ui/grid/editors/AbstractZonedTimeDelegate", "create"));
        }
        LocalTime localTime = OffsetTime.from(value).withOffsetSameInstant(OffsetTime.now().getOffset()).toLocalTime();
        return new TimeZonedTime(Time.valueOf(localTime), stringRepresentation);
    }

    private static TemporalAccessor extractOffsetTime(TemporalAccessor temporal) {
        OffsetTime offsetTime = OffsetTime.from(temporal);
        ZoneOffset offset = offsetTime.getOffset();
        if (MAX_ZONE_OFFSET.compareTo(offset) > 0 || MIN_ZONE_OFFSET.compareTo(offset) < 0) {
            throw new DateTimeException(ERROR_MESSAGE);
        }
        return offsetTime;
    }

    private static TemporalAccessor extractWithLocalOffset(TemporalAccessor temporal) {
        if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            throw new DateTimeException(ERROR_MESSAGE);
        }
        return LocalTime.from(temporal).atOffset(OffsetTime.now().getOffset());
    }
}

