/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.IntIntFunction;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.ui.table.JBTable;
import org.jetbrains.annotations.NotNull;

public final class GridRawIndexConverter
implements RawIndexConverter {
    private final JBTable myTable;
    private boolean myTranspose;

    public GridRawIndexConverter(@NotNull JBTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridRawIndexConverter", "<init>"));
        }
        this.myTable = table;
    }

    @Override
    public boolean isValidViewRowIdx(int viewRowIdx) {
        return viewRowIdx >= 0 && viewRowIdx < (this.myTranspose ? this.myTable.getColumnCount() : this.myTable.getRowCount());
    }

    @Override
    public boolean isValidViewColumnIdx(int viewColumnIdx) {
        return viewColumnIdx >= 0 && viewColumnIdx < (this.myTranspose ? this.myTable.getRowCount() : this.myTable.getColumnCount());
    }

    @Override
    @NotNull
    public IntIntFunction row2View() {
        IntIntFunction intIntFunction = new IntIntFunction(){

            @Override
            public int fun(int index) {
                if (!GridRawIndexConverter.this.isValidModelRowIdx(index)) {
                    return -1;
                }
                return GridRawIndexConverter.this.myTranspose ? GridRawIndexConverter.this.myTable.convertColumnIndexToView(index) : GridRawIndexConverter.this.myTable.convertRowIndexToView(index);
            }
        };
        if (intIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridRawIndexConverter", "row2View"));
        }
        return intIntFunction;
    }

    @Override
    @NotNull
    public IntIntFunction column2View() {
        IntIntFunction intIntFunction = new IntIntFunction(){

            @Override
            public int fun(int index) {
                if (!GridRawIndexConverter.this.isValidModelColumnIdx(index)) {
                    return -1;
                }
                return GridRawIndexConverter.this.myTranspose ? GridRawIndexConverter.this.myTable.convertRowIndexToView(index) : GridRawIndexConverter.this.myTable.convertColumnIndexToView(index);
            }
        };
        if (intIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridRawIndexConverter", "column2View"));
        }
        return intIntFunction;
    }

    @Override
    @NotNull
    public IntIntFunction row2Model() {
        IntIntFunction intIntFunction = new IntIntFunction(){

            @Override
            public int fun(int index) {
                if (!GridRawIndexConverter.this.isValidViewRowIdx(index)) {
                    return -1;
                }
                return GridRawIndexConverter.this.myTranspose ? GridRawIndexConverter.this.myTable.convertColumnIndexToModel(index) : GridRawIndexConverter.this.myTable.convertRowIndexToModel(index);
            }
        };
        if (intIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridRawIndexConverter", "row2Model"));
        }
        return intIntFunction;
    }

    @Override
    @NotNull
    public IntIntFunction column2Model() {
        IntIntFunction intIntFunction = new IntIntFunction(){

            @Override
            public int fun(int index) {
                if (!GridRawIndexConverter.this.isValidViewColumnIdx(index)) {
                    return -1;
                }
                return GridRawIndexConverter.this.myTranspose ? GridRawIndexConverter.this.myTable.convertRowIndexToModel(index) : GridRawIndexConverter.this.myTable.convertColumnIndexToModel(index);
            }
        };
        if (intIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridRawIndexConverter", "column2Model"));
        }
        return intIntFunction;
    }

    public void transpose() {
        this.myTranspose = !this.myTranspose;
    }

    private boolean isValidModelRowIdx(int modelRowIdx) {
        return modelRowIdx >= 0 && modelRowIdx < (this.myTranspose ? this.myTable.getModel().getColumnCount() : this.myTable.getModel().getRowCount());
    }

    private boolean isValidModelColumnIdx(int modelColumnIdx) {
        return modelColumnIdx >= 0 && modelColumnIdx < (this.myTranspose ? this.myTable.getModel().getRowCount() : this.myTable.getModel().getColumnCount());
    }
}

