/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CellRenderingUtils {
    public static final Insets NAME_LABEL_INSETS = JBUI.insets((int)2, (int)3, (int)2, (int)0);
    public static final Insets SORT_LABEL_INSETS = JBUI.insets((int)2, (int)2, (int)2, (int)3);
    public static final Insets NAME_LABEL_ROW_INSETS = JBUI.insets((int)0, (int)3, (int)0, (int)0);
    public static final Insets SORT_LABEL_ROW_INSETS = JBUI.insets((int)0, (int)2, (int)0, (int)3);

    public static void paintCellEffect(@NotNull Graphics g, @NotNull Rectangle cellRect, @NotNull CellAttributes attributes, @Nullable Color effectColor) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/run/ui/grid/CellRenderingUtils", "paintCellEffect"));
        }
        if (cellRect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRect", "com/intellij/database/run/ui/grid/CellRenderingUtils", "paintCellEffect"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/run/ui/grid/CellRenderingUtils", "paintCellEffect"));
        }
        if (attributes.isUnderlined() && effectColor != null) {
            g.setColor(effectColor);
            g.drawLine((int)cellRect.getMinX(), (int)cellRect.getMaxY() - 1, (int)cellRect.getMaxX(), (int)cellRect.getMaxY() - 1);
        }
    }

    public static void paintCellEffect(@NotNull Graphics g, @NotNull Rectangle cellRect, @NotNull CellAttributes attributes) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/run/ui/grid/CellRenderingUtils", "paintCellEffect"));
        }
        if (cellRect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRect", "com/intellij/database/run/ui/grid/CellRenderingUtils", "paintCellEffect"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/run/ui/grid/CellRenderingUtils", "paintCellEffect"));
        }
        CellRenderingUtils.paintCellEffect(g, cellRect, attributes, attributes.getEffectColor());
    }

    public static void processVisibleRows(@NotNull JTable table, @NotNull Graphics g, @NotNull RowProcessor proc) {
        int rowHeight;
        int rowHeight2;
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/CellRenderingUtils", "processVisibleRows"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/run/ui/grid/CellRenderingUtils", "processVisibleRows"));
        }
        if (proc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proc", "com/intellij/database/run/ui/grid/CellRenderingUtils", "processVisibleRows"));
        }
        Rectangle clip = g.getClipBounds();
        int rowCount = table.getRowCount();
        int startY = table.getRowMargin() / 2;
        for (int startRow = 0; startRow < rowCount && startY + (rowHeight2 = table.getRowHeight(startRow)) < clip.y; ++startRow) {
            startY += rowHeight2;
        }
        int y = startY;
        for (int row = startRow; row < rowCount && y <= clip.y + clip.height && proc.process(row, y); y += rowHeight, ++row) {
            rowHeight = table.getRowHeight(row);
        }
    }

    public static interface RowProcessor {
        public boolean process(int var1, int var2);
    }
}

