/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;

public class SubmitMutations
extends DumbAwareAction
implements GridAction {
    public void update(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GridDataSupport support = dataGrid.getDataSupport();
        boolean hasChanges = support.hasPendingChanges();
        boolean isReadOnly = dataGrid.getDataHookup().isReadOnly();
        boolean visible = (!support.isSubmitImmediately() || hasChanges) && !isReadOnly;
        boolean enabled = visible && hasChanges && !dataGrid.isEditing();
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null) {
            dataGrid.submit();
        }
    }
}

