/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.EditValueAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class EditValueInMaximizedCellEditorAction
extends EditValueAction {
    @Override
    boolean isEnabled(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/EditValueInMaximizedCellEditorAction", "isEnabled"));
        }
        return super.isEnabled(grid) && grid.getSelectionModel().getSelectedRowCount() == 1 && grid.getSelectionModel().getSelectedColumnCount() == 1;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        super.actionPerformed(e);
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null) {
            dataGrid.maximizeEditingCell();
        }
    }

    @Override
    protected String getText(boolean viewMode) {
        return super.getText(viewMode) + " Maximized";
    }

    @Override
    protected String getDescription(boolean viewMode) {
        return super.getDescription(viewMode) + " in maximized editor";
    }
}

