/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.actions.AddColumnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;

public class CloneColumnAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean singleColumnSelected = dataGrid != null && dataGrid.getSelectionModel().getSelectedColumnCount() == 1;
        boolean canAddRow = AddColumnAction.canAddColumn(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(singleColumnSelected && canAddRow);
    }

    public void actionPerformed(AnActionEvent e) {
        ModelIndex<DataConsumer.Column> selectedColumn;
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        ModelIndex<DataConsumer.Column> modelIndex = selectedColumn = dataGrid != null ? dataGrid.getSelectionModel().getSelectedColumn() : null;
        if (selectedColumn != null && selectedColumn.isValid(dataGrid)) {
            dataGrid.cloneColumn(selectedColumn);
        }
    }
}

