/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;

public class DbQualifiedNameProvider
implements QualifiedNameProvider {
    public PsiElement adjustElementToCopy(PsiElement element) {
        return element instanceof DbElement ? element : null;
    }

    public String getQualifiedName(PsiElement element) {
        return element instanceof DbElement ? QNameUtil.getQualifiedName((DbElement)element) : null;
    }

    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            DasObject result = (DasObject)QNameUtil.findByQName(dataSource.getModel(), fqn, (Function<DasObject, String>)DasUtil.TO_NAME).first();
            if (result == null) continue;
            return (DbElement)result;
        }
        return null;
    }

    public void insertQualifiedName(String fqn, PsiElement element, Editor editor, Project project) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)fqn);
    }
}

