/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicDbPsiManager<T extends DatabaseSystem>
extends DbPsiManagerSpi {
    @NotNull
    private final Map<T, DbDataSource> myDataSourcesMap;
    @NotNull
    protected final DbPsiFacade myDbFacade;

    protected BasicDbPsiManager(@NotNull DbPsiFacade dbFacade, @NotNull List<? extends T> sources) {
        if (dbFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFacade", "com/intellij/database/psi/BasicDbPsiManager", "<init>"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/psi/BasicDbPsiManager", "<init>"));
        }
        this.myDbFacade = dbFacade;
        this.myDataSourcesMap = Collections.synchronizedMap(ContainerUtil.newLinkedHashMap());
        if (!sources.isEmpty()) {
            this.resetElementMap(sources);
        }
        Disposer.register((Disposable)this.myDbFacade.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                BasicDbPsiManager.this.detachAll();
            }
        });
    }

    protected void resetElementMap(@NotNull List<? extends T> sources) {
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/psi/BasicDbPsiManager", "resetElementMap"));
        }
        HashSet<T> oldSources = new HashSet<T>(this.myDataSourcesMap.keySet());
        HashSet<T> newSources = new HashSet<T>(sources);
        for (DatabaseSystem source : oldSources) {
            if (newSources.contains(source)) continue;
            this.detachDataSource(source);
        }
        for (DatabaseSystem source : newSources) {
            DbDataSource existentWrapper = this.myDataSourcesMap.get(source);
            if (existentWrapper == null) {
                this.attachDataSource(source);
                continue;
            }
            existentWrapper.clearCaches();
        }
    }

    public void attachDataSource(@NotNull T source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/psi/BasicDbPsiManager", "attachDataSource"));
        }
        DbDataSource wrapper = this.createDataSourceElement(source);
        this.myDataSourcesMap.put(source, wrapper);
        this.dataSourceAttached(source, wrapper);
    }

    public void detachDataSource(@NotNull T source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/psi/BasicDbPsiManager", "detachDataSource"));
        }
        DbDataSource wrapper = this.myDataSourcesMap.remove(source);
        if (wrapper != null) {
            this.dataSourceDetached(source, wrapper);
        }
    }

    private void detachAll() {
        if (this.myDataSourcesMap.isEmpty()) {
            return;
        }
        ArrayList<T> sources = new ArrayList<T>(this.myDataSourcesMap.keySet());
        for (DatabaseSystem source : sources) {
            this.detachDataSource(source);
        }
    }

    protected void dataSourceAttached(@NotNull T source, @NotNull DbDataSource wrapper) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/psi/BasicDbPsiManager", "dataSourceAttached"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/database/psi/BasicDbPsiManager", "dataSourceAttached"));
        }
    }

    protected void dataSourceDetached(@NotNull T source, @NotNull DbDataSource wrapper) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/psi/BasicDbPsiManager", "dataSourceDetached"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/database/psi/BasicDbPsiManager", "dataSourceDetached"));
        }
    }

    @NotNull
    protected DbDataSource createDataSourceElement(@NotNull T info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/psi/BasicDbPsiManager", "createDataSourceElement"));
        }
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)this.myDbFacade).createDataSourceWrapperElement((DatabaseSystem)info, this);
        if (dbDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/BasicDbPsiManager", "createDataSourceElement"));
        }
        return dbDataSource;
    }

    @Nullable
    public DbDataSource getDataSourceWrapper(@Nullable T dataSource) {
        if (dataSource == null) {
            return null;
        }
        return this.myDataSourcesMap.get(dataSource);
    }

    public List<DbDataSource> getDataSources() {
        return new ArrayList<DbDataSource>(this.myDataSourcesMap.values());
    }

    @Override
    public boolean isDataSourceElementValid(@NotNull DbDataSource element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/BasicDbPsiManager", "isDataSourceElementValid"));
        }
        return this.myDataSourcesMap.containsKey(element.getDelegate());
    }

    public abstract void addDataSource(@NotNull T var1);
}

