/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.postgres;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.postgres.PostgresPlanModelBuilder;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresExplainPlanProvider
extends ExplainPlanProvider {
    @Override
    @NotNull
    public String getName() {
        if ("PostgreSQL 9.0+" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/postgres/PostgresExplainPlanProvider", "getName"));
        }
        return "PostgreSQL 9.0+";
    }

    @Override
    public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/postgres/PostgresExplainPlanProvider", "isAvailableFor"));
        }
        return DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource).isPostgres();
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/postgres/PostgresExplainPlanProvider", "createExplainRequest"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/postgres/PostgresExplainPlanProvider", "createExplainRequest"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/postgres/PostgresExplainPlanProvider", "createExplainRequest"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/postgres/PostgresExplainPlanProvider", "createExplainRequest"));
        }
        return new PostgresPlanModelBuilder(owner, consumer, statement);
    }
}

