/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.mysql;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlPlanModelBuilder
extends AbstractPlanModelBuilder<MetaNode> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private static final Map<String, PlanModel.NodeType> EXTRA_MAPPING = ContainerUtil.newHashMap();
    private final String myStatement;
    private final List<PlanRow> myRows;
    private Slicing mySlicing;
    private static final Pattern UNION_RESULT_PATTERN = Pattern.compile("<union(\\d+(,(\\d+|\\.\\.\\.))*)>");
    private static final Pattern DERIVED_PATTERN = Pattern.compile("<derived(\\d+)>");

    public MysqlPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull String statement) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "<init>"));
        }
        super(owner, consumer, EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST));
        this.myRows = ContainerUtil.newArrayList();
        this.myStatement = statement;
    }

    private void getData(@NotNull Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "getData"));
        }
        MysqlPlanModelBuilder.useStatementWithPreserved(connection, new AbstractPlanModelBuilder.ResourceUser<Statement>(){

            @Override
            public void use(Statement statement) throws PlanRetrievalException, SQLException {
                statement.execute("EXPLAIN EXTENDED " + MysqlPlanModelBuilder.this.myStatement);
                MysqlPlanModelBuilder.useResults(statement, new AbstractPlanModelBuilder.ResourceUser<ResultSet>(){

                    @Override
                    public void use(ResultSet resultSet) throws PlanRetrievalException, SQLException {
                        if (resultSet == null) {
                            throw new PlanRetrievalException("No data returned for plan query");
                        }
                        while (resultSet.next()) {
                            MysqlPlanModelBuilder.this.myRows.add(new PlanRow(resultSet.getInt("id"), resultSet.getInt("key_len"), resultSet.getDouble("filtered"), resultSet.getString("select_type"), resultSet.getString("table"), resultSet.getString("type"), resultSet.getString("possible_keys"), resultSet.getString("key"), resultSet.getString("ref"), resultSet.getBigDecimal("rows"), StringUtil.notNullize((String)resultSet.getString("Extra"))));
                        }
                        if (MysqlPlanModelBuilder.this.myRows.isEmpty()) {
                            throw new PlanRetrievalException("Database returned empty plan");
                        }
                    }
                });
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
    }

    @Override
    @NotNull
    protected String dump() {
        StringBuilder sb = new StringBuilder();
        for (PlanRow row : this.myRows) {
            sb.append("\t").append(row.id).append("\t").append(row.selectType).append("\t").append(row.table).append("\t").append(row.type).append("\t").append(row.possibleKeys).append("\t").append(row.key).append("\t").append(row.keyLen).append("\t").append(row.ref).append("\t").append(row.rows).append("\t").append(row.filtered).append("\t").append(row.extra).append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "dump"));
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull Connection connection) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "processRaw"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "processRaw"));
        }
        this.getData(connection);
        this.showRaw();
        this.processData();
    }

    @Override
    public void processDump(@NotNull String dump) {
        if (dump == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dump", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "processDump"));
        }
        this.parseDump(dump);
        this.processData();
    }

    private void parseDump(@NotNull String dump) {
        if (dump == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dump", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseDump"));
        }
        this.myRows.clear();
        for (String line : dump.split("\\n")) {
            List split = StringUtil.split((String)line, (String)"\t", (boolean)true, (boolean)false);
            assert (split.size() == 12);
            this.myRows.add(new PlanRow(Integer.parseInt((String)split.get(1)), Integer.parseInt((String)split.get(7)), Double.parseDouble((String)split.get(10)), (String)split.get(2), (String)split.get(3), (String)split.get(4), (String)split.get(5), (String)split.get(6), (String)split.get(8), new BigDecimal((String)split.get(9)), (String)split.get(11)));
        }
    }

    private void processData() {
        int max = -1;
        for (PlanRow row : this.myRows) {
            max = Math.max(max, row.id);
        }
        this.mySlicing = new Slicing(max);
        for (PlanRow row : this.myRows) {
            String[] sids;
            Matcher matcher;
            if (!"UNION RESULT".equals(row.selectType) || !(matcher = UNION_RESULT_PATTERN.matcher(row.table)).matches() || (sids = matcher.group(1).split(",")).length == 0) continue;
            int i2 = 0;
            int cur = Integer.parseInt(sids[0]);
            while (i2 < sids.length) {
                int prev = cur;
                ++i2;
                while (i2 < sids.length) {
                    int next = "...".equals(sids[i2]) ? -1 : Integer.parseInt(sids[i2]);
                    boolean gap = prev != -1 && next != -1 && next != prev + 1;
                    prev = next;
                    if (gap) break;
                    ++i2;
                }
                this.mySlicing.slice(cur);
                cur = prev;
            }
        }
        MetaNode structure = this.parseStructure();
        this.openNode();
        this.openNode();
        this.parsePlan(structure);
        this.closeNode(this.createNode(null, PlanModel.NodeType.SELECT, null));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.modelReady();
    }

    private void parseStructureItem(int rowId, List<TIntArrayList> unionResults, TIntObjectHashMap<List<MetaNode>> metaQueries, TIntObjectHashMap<MetaNode> metaQueriesRoot, List<MetaNode> delayed, TIntHashSet usedSubqueries) {
        List others;
        MetaNode node;
        PlanRow curRow = this.myRows.get(rowId);
        if ("UNION RESULT".equals(curRow.selectType)) {
            Matcher matcher = UNION_RESULT_PATTERN.matcher(curRow.table);
            if (!matcher.matches()) {
                this.unsupportedFormat("`" + curRow.table + "` does not match `" + UNION_RESULT_PATTERN.pattern() + "`");
            }
            TIntArrayList res = new TIntArrayList();
            String[] sids = matcher.group(1).split(",");
            for (int i2 = 0; i2 < sids.length; ++i2) {
                int to;
                int from;
                if (sids[i2].equals("...")) {
                    from = Integer.parseInt(sids[i2 - 1]);
                    to = i2 + 1 < sids.length ? Integer.parseInt(sids[i2 + 1]) : this.mySlicing.next(from);
                } else {
                    from = Integer.parseInt(sids[i2]);
                    to = from + 1;
                }
                for (int id = from; id < to; ++id) {
                    usedSubqueries.add(id);
                    res.add(id);
                }
            }
            unionResults.add(res);
            return;
        }
        if (curRow.table != null) {
            MetaNode.Type type;
            Matcher matcher = DERIVED_PATTERN.matcher(curRow.table);
            int subId = -1;
            if (matcher.matches()) {
                type = MetaNode.Type.SUBQUERY;
                subId = Integer.parseInt(matcher.group(1));
                usedSubqueries.add(subId);
            } else {
                type = MetaNode.Type.SELECT;
            }
            node = new MetaNode(rowId, type, subId);
        } else {
            node = new MetaNode(PlanModel.NodeType.VALUE, curRow.type, rowId);
        }
        if (node.type == MetaNode.Type.SUBQUERY) {
            delayed.add(node);
        }
        if ((others = (List)metaQueries.get(curRow.id)) == null) {
            metaQueriesRoot.put(curRow.id, (Object)node);
            others = ContainerUtil.newArrayList();
            metaQueries.put(curRow.id, (Object)others);
        }
        others.add(this.expandStructure(node));
    }

    @NotNull
    private MetaNode expandStructure(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "expandStructure"));
        }
        if (node.rowId != -1) {
            String[] clauses;
            for (String clause : clauses = this.myRows.get((int)node.rowId).extra.split("; ")) {
                PlanModel.NodeType type = EXTRA_MAPPING.get(clause);
                if (type == null) continue;
                MetaNode tmp = new MetaNode(type, clause, node.rowId);
                tmp.children.add(node);
                node = tmp;
            }
        }
        MetaNode metaNode = node;
        if (metaNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "expandStructure"));
        }
        return metaNode;
    }

    private int bindScalarSubqueryItem(TIntObjectHashMap<MetaNode> metaQueriesRoot, TIntHashSet usedSubqueries, List<MetaNode> delayed, int from) {
        MetaNode target = (MetaNode)metaQueriesRoot.get(this.myRows.get((int)from).id);
        int targetIdx = target.children.size();
        int i2 = from + 1;
        while (i2 < this.myRows.size()) {
            if (this.myRows.get((int)i2).id == this.myRows.get((int)from).id) {
                ++i2;
                continue;
            }
            if (usedSubqueries.contains(this.myRows.get((int)i2).id) || this.myRows.get((int)i2).id < this.myRows.get((int)from).id) break;
            MetaNode node = new MetaNode(-1, MetaNode.Type.SUBQUERY, this.myRows.get((int)i2).id);
            target.children.add(targetIdx, node);
            delayed.add(node);
            i2 = this.bindScalarSubqueryItem(metaQueriesRoot, usedSubqueries, delayed, i2);
        }
        return i2;
    }

    private void bindScalarSubqueries(TIntObjectHashMap<MetaNode> metaQueriesRoot, TIntHashSet usedSubqueries, List<MetaNode> delayed) {
        if (this.myRows.get((int)0).id != 1) {
            this.unsupportedFormat();
        }
        int i2 = 0;
        while (i2 < this.myRows.size()) {
            if (usedSubqueries.contains(this.myRows.get((int)i2).id)) {
                i2 = this.bindScalarSubqueryItem(metaQueriesRoot, usedSubqueries, delayed, i2);
                continue;
            }
            ++i2;
        }
    }

    private MetaNode parseStructure() {
        ArrayList unionResults = ContainerUtil.newArrayList();
        ArrayList delayed = ContainerUtil.newArrayList();
        TIntHashSet usedSubqueries = new TIntHashSet();
        usedSubqueries.add(1);
        TIntObjectHashMap metaQueries = new TIntObjectHashMap();
        TIntObjectHashMap metaQueriesRoot = new TIntObjectHashMap();
        for (int i2 = 0; i2 < this.myRows.size(); ++i2) {
            this.parseStructureItem(i2, unionResults, (TIntObjectHashMap<List<MetaNode>>)metaQueries, (TIntObjectHashMap<MetaNode>)metaQueriesRoot, delayed, usedSubqueries);
        }
        this.bindScalarSubqueries((TIntObjectHashMap<MetaNode>)metaQueriesRoot, usedSubqueries, delayed);
        for (TIntArrayList result : unionResults) {
            this.createUnionNodes(result, (TIntObjectHashMap<List<MetaNode>>)metaQueries);
        }
        for (MetaNode node : delayed) {
            assert (node.subId != -1);
            node.children.add(this.createJoinNodes(node.subId, (TIntObjectHashMap<List<MetaNode>>)metaQueries).get(0));
        }
        return this.createJoinNodes(1, (TIntObjectHashMap<List<MetaNode>>)metaQueries).get(0);
    }

    private List<MetaNode> createJoinNodes(int id, TIntObjectHashMap<List<MetaNode>> metaQueries) {
        List nodes2 = (List)metaQueries.get(id);
        if (nodes2 == null) {
            this.unsupportedFormat();
        }
        if (nodes2.size() != 1) {
            MetaNode loop = new MetaNode(PlanModel.NodeType.NESTED_LOOPS, null, ((MetaNode)nodes2.get((int)0)).rowId);
            loop.children.addAll(nodes2);
            nodes2.clear();
            nodes2.add(loop);
        }
        return nodes2;
    }

    private void createUnionNodes(@NotNull TIntArrayList result, TIntObjectHashMap<List<MetaNode>> metaQueries) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "createUnionNodes"));
        }
        List<MetaNode> output = this.createJoinNodes(result.get(0), metaQueries);
        for (int i2 = 1; i2 < result.size(); ++i2) {
            output.add(this.createJoinNodes(result.get(i2), metaQueries).get(0));
        }
        if (output.size() != 1) {
            MetaNode loop = new MetaNode(PlanModel.NodeType.UNION, null, output.get((int)0).rowId);
            loop.children.addAll(output);
            output.clear();
            output.add(loop);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseRawDescription"));
        }
        String string = node.rowId == -1 ? "" : this.myRows.get((int)node.rowId).extra;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseRawDescription"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseAccessRelation"));
        }
        return node.rowId == -1 ? null : this.myRows.get((int)node.rowId).table;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parsePlanNumRows"));
        }
        return node.rowId == -1 ? null : this.myRows.get((int)node.rowId).rows;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseAccessIndex"));
        }
        return node.rowId == -1 ? "" : this.myRows.get((int)node.rowId).key;
    }

    @Override
    protected void parsePlan(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parsePlan"));
        }
        this.openNode();
        this.parseSubPlans(node);
        PlanModel.NodeType type = PlanModel.NodeType.UNKNOWN;
        String typeStr = null;
        switch (node.type) {
            case SELECT: {
                typeStr = this.myRows.get((int)node.rowId).type;
                type = TYPE_MAPPING.get(typeStr);
                if (type != null) break;
                type = PlanModel.NodeType.ACCESS;
                break;
            }
            case TYPE: {
                type = node.nodeType;
                typeStr = node.nodeTypeStr;
                break;
            }
            case SUBQUERY: {
                type = PlanModel.NodeType.SUBQUERY;
            }
        }
        PlanModel.GenericNode res = this.createNode(node, type, typeStr);
        this.closeNode(res);
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseSubPlans"));
        }
        for (MetaNode child : node.children) {
            this.parsePlan(child);
        }
    }

    @Override
    protected void parseStatement(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseStatement"));
        }
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseTotalCost"));
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseStartupCost"));
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseSubqueryCorrelated"));
        }
        MetaNode target = null;
        for (MetaNode child : node.children) {
            if (child.rowId == -1) continue;
            PlanRow row = this.myRows.get(child.rowId);
            if (node.subId != row.id) continue;
            if (target != null) {
                this.unsupportedFormat();
            }
            target = child;
        }
        if (target == null) {
            this.unsupportedFormat();
        }
        return this.myRows.get((int)target.rowId).selectType.startsWith("DEPENDENT");
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder", "parseSubqueryScalar"));
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("system", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("const", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("eq_ref", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("ref", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("fulltext", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("ref_or_null", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("index_merge", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("unique_subquery", PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        TYPE_MAPPING.put("index_subquery", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("range", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("index", PlanModel.NodeType.FULL_INDEX_SCAN);
        TYPE_MAPPING.put("ALL", PlanModel.NodeType.SEQ_SCAN);
        EXTRA_MAPPING.put("Using filesort", PlanModel.NodeType.SORT);
        EXTRA_MAPPING.put("Using temporary", PlanModel.NodeType.TEMPORARY);
    }

    public static class Slicing {
        private final int myMax;
        private final SortedSet<Integer> mySlicePoints = ContainerUtil.newTreeSet();

        private Slicing(int max) {
            this.myMax = max;
        }

        public void slice(int point) {
            this.mySlicePoints.add(point);
        }

        public int next(int point) {
            SortedSet<Integer> head = this.mySlicePoints.tailSet(point + 1);
            return head.isEmpty() ? this.myMax : head.first();
        }
    }

    public static class MetaNode {
        public final int rowId;
        public final int subId;
        public final Type type;
        public final PlanModel.NodeType nodeType;
        public final String nodeTypeStr;
        public final List<MetaNode> children;

        private MetaNode(int id, Type type, int subId) {
            this.children = ContainerUtil.newArrayListWithCapacity((int)0);
            this.rowId = id;
            this.type = type;
            this.subId = subId;
            this.nodeType = null;
            this.nodeTypeStr = null;
        }

        private MetaNode(@NotNull PlanModel.NodeType type, @Nullable String typeStr, int rowId) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/mysql/MysqlPlanModelBuilder$MetaNode", "<init>"));
            }
            this.children = ContainerUtil.newArrayListWithCapacity((int)0);
            this.rowId = rowId;
            this.type = Type.TYPE;
            this.subId = -1;
            this.nodeType = type;
            this.nodeTypeStr = typeStr;
        }

        static enum Type {
            SELECT,
            SUBQUERY,
            TYPE;

        }
    }

    private static class PlanRow {
        public final int id;
        public final int keyLen;
        public final BigDecimal rows;
        public final double filtered;
        public final String selectType;
        public final String table;
        public final String type;
        public final String possibleKeys;
        public final String key;
        public final String ref;
        public final String extra;

        private PlanRow(int id, int keyLen, double filtered, String selectType, String table, String type, String possibleKeys, String key, String ref, BigDecimal rows, String extra) {
            this.id = id;
            this.keyLen = keyLen;
            this.filtered = filtered;
            this.selectType = selectType;
            this.table = table;
            this.type = type;
            this.possibleKeys = possibleKeys;
            this.key = key;
            this.ref = ref;
            this.rows = rows;
            this.extra = extra;
        }
    }
}

