/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.mysql;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.mysql.MysqlPlanModelBuilder;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlExplainPlanProvider
extends ExplainPlanProvider {
    @Override
    @NotNull
    public String getName() {
        if ("MySQL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/mysql/MysqlExplainPlanProvider", "getName"));
        }
        return "MySQL";
    }

    @Override
    public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/mysql/MysqlExplainPlanProvider", "isAvailableFor"));
        }
        return DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource).isMysql();
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/mysql/MysqlExplainPlanProvider", "createExplainRequest"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/mysql/MysqlExplainPlanProvider", "createExplainRequest"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/mysql/MysqlExplainPlanProvider", "createExplainRequest"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/mysql/MysqlExplainPlanProvider", "createExplainRequest"));
        }
        return new MysqlPlanModelBuilder(owner, consumer, statement);
    }
}

