/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.mssql;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.mssql.MssqlPlanModelBuilder;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlExplainPlanProvider
extends ExplainPlanProvider {
    @Override
    @NotNull
    public String getName() {
        if ("MS SQL Server" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/mssql/MssqlExplainPlanProvider", "getName"));
        }
        return "MS SQL Server";
    }

    @Override
    public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/mssql/MssqlExplainPlanProvider", "isAvailableFor"));
        }
        return DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource).isMicrosoft();
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/mssql/MssqlExplainPlanProvider", "createExplainRequest"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/mssql/MssqlExplainPlanProvider", "createExplainRequest"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/mssql/MssqlExplainPlanProvider", "createExplainRequest"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/mssql/MssqlExplainPlanProvider", "createExplainRequest"));
        }
        return new MssqlPlanModelBuilder(owner, consumer, statement);
    }
}

