/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.util.Consumer;
import java.util.EnumSet;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlPlanModelBuilder<State>
extends AbstractPlanModelBuilder<State> {
    protected final XPath XPATH;

    protected AbstractXmlPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull EnumSet<PlanModel.Feature> unsupportedFeatures) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "<init>"));
        }
        if (unsupportedFeatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsupportedFeatures", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "<init>"));
        }
        super(owner, consumer, unsupportedFeatures);
        this.XPATH = XPathFactory.newInstance().newXPath();
    }

    protected XPathExpression compileXPath(@Language(value="XPath") @NotNull String expr) throws PlanRetrievalException {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "compileXPath"));
        }
        try {
            return this.XPATH.compile(expr);
        }
        catch (XPathExpressionException e) {
            throw new PlanRetrievalException("Failed to compile xpath expression", e);
        }
    }

    protected static Object queryXPath(@NotNull XPathExpression xpath, @NotNull Element node, @NotNull QName type) {
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryXPath"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryXPath"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryXPath"));
        }
        try {
            return xpath.evaluate(node, type);
        }
        catch (XPathExpressionException e) {
            throw new PlanRetrievalException("XPath execution failed", e);
        }
    }

    @Nullable
    protected static Element queryElement(@NotNull XPathExpression xpath, @NotNull Element node) {
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryElement"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryElement"));
        }
        return (Element)AbstractXmlPlanModelBuilder.queryXPath(xpath, node, XPathConstants.NODE);
    }

    @Nullable
    protected Element querySingleElement(@NotNull XPathExpression xpath, @NotNull Element node) {
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "querySingleElement"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "querySingleElement"));
        }
        NodeList list = AbstractXmlPlanModelBuilder.queryElements(xpath, node);
        if (list.getLength() > 1) {
            this.unsupportedFormat();
        }
        return list.getLength() == 1 ? (Element)list.item(0) : null;
    }

    @NotNull
    protected static NodeList queryElements(@NotNull XPathExpression xpath, @NotNull Element node) {
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryElements"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryElements"));
        }
        NodeList nodeList = (NodeList)AbstractXmlPlanModelBuilder.queryXPath(xpath, node, XPathConstants.NODESET);
        if (nodeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/AbstractXmlPlanModelBuilder", "queryElements"));
        }
        return nodeList;
    }
}

