/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TrigEvent {
    SELECT('S'),
    INSERT('I'),
    UPDATE('U'),
    DELETE('D');

    public final char code;

    private TrigEvent(char code) {
        this.code = code;
    }

    @Nullable
    public static TrigEvent of(char code) {
        switch (code) {
            case 'S': 
            case 's': {
                return SELECT;
            }
            case 'I': 
            case 'i': {
                return INSERT;
            }
            case 'U': 
            case 'u': {
                return UPDATE;
            }
            case 'D': 
            case 'd': {
                return DELETE;
            }
        }
        return null;
    }

    @NotNull
    public static Set<TrigEvent> of(@Nullable String codes) {
        if (codes == null || codes.isEmpty()) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/TrigEvent", "of"));
            }
            return set;
        }
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        int n = codes.length();
        for (int i2 = 0; i2 < n; ++i2) {
            TrigEvent event = TrigEvent.of(codes.charAt(i2));
            if (event == null) continue;
            events.add(event);
        }
        EnumSet<TrigEvent> enumSet = events;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/TrigEvent", "of"));
        }
        return enumSet;
    }
}

