/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresLikeStoredTable;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresSourceAware;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgres.PostgresViewColumn;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresView
extends PostgresLikeStoredTable,
BasicView,
PostgresSourceAware {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.VIEW;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresSchema getSchema();

    @Override
    @Nullable
    default public PostgresSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresView> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends PostgresViewColumn> getColumns();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresRule> getRules();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresTrigger> getTriggers();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.RULE, ObjectKind.TRIGGER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getRules(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append(this.getRules()).append(this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getErrors"));
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @NotNull
    default public PostgresCheckOption getCheckOption() {
        PostgresCheckOption postgresCheckOption = PostgresCheckOption.NONE;
        if (postgresCheckOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getCheckOption"));
        }
        return postgresCheckOption;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        PostgresCheckOption checkOption;
        boolean invalid;
        long stateNumber;
        boolean system;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresView", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", PropertyConverter.export(invalid));
        }
        if ((checkOption = this.getCheckOption()) != null && checkOption != PostgresCheckOption.NONE) {
            consumer.accept("CheckOption", PropertyConverter.export(checkOption));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "Comment", "System", "StateNumber", "Errors", "Invalid", "CheckOption");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresView", "getPropertyNames"));
        }
        return list;
    }
}

