/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresModCatalogObject;
import com.intellij.database.model.postgres.PostgresModDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModDefType
extends PostgresDefType,
PostgresModCatalogObject,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getDbParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModDefType", "getDbParent"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModDefType> getParentFamily();

    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModDefTypeAttribute> getAttributes();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<PositioningNamingFamily> list = Collections.singletonList(this.getAttributes());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModDefType", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getAttributes());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModDefType", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setStateNumber(long var1);

    public void setSubKind(@NotNull PostgresDataTypeSubKind var1);

    public void setSubCategory(@NotNull PostgresDataTypeSubCategory var1);

    public void setDefinition(@Nullable String var1);

    public void setLabels(@NotNull List<String> var1);

    default public void setLabels(String ... labels) {
        this.setLabels(Arrays.asList(labels));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModDefType", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String stateNumber = properties.get("StateNumber");
        String subKind = properties.get("SubKind");
        String subCategory = properties.get("SubCategory");
        String definition = properties.get("Definition");
        String labels = properties.get("Labels");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (subKind != null) {
            this.setSubKind(PropertyConverter.importPostgresDataTypeSubKind(subKind));
        }
        if (subCategory != null) {
            this.setSubCategory(PropertyConverter.importPostgresDataTypeSubCategory(subCategory));
        }
        if (definition != null) {
            this.setDefinition(PropertyConverter.importString(definition));
        }
        if (labels != null) {
            this.setLabels(PropertyConverter.importListOfString(labels));
        }
    }
}

