/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.oracle.OraModArgument;
import com.intellij.database.model.oracle.OraModInnerRoutine;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraObjectTypeRoutine;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModObjectTypeRoutine
extends OraObjectTypeRoutine,
OraModInnerRoutine {
    @Override
    @NotNull
    public OraModObjectType getObjectType();

    @Override
    @NotNull
    default public OraModObjectType getDbParent() {
        OraModObjectType oraModObjectType = this.getObjectType();
        if (oraModObjectType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModObjectTypeRoutine", "getDbParent"));
        }
        return oraModObjectType;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends OraModObjectTypeRoutine> getParentFamily();

    @Override
    @NotNull
    default public OraModSchema getSchema() {
        OraModSchema oraModSchema = this.getObjectType().getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModObjectTypeRoutine", "getSchema"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends OraModArgument> getArguments();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<PositioningNamingFamily> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModObjectTypeRoutine", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getArguments());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModObjectTypeRoutine", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setRoutineKind(@NotNull DasRoutine.Kind var1);

    @Override
    public void setDeterministic(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModObjectTypeRoutine", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String routineKind = properties.get("RoutineKind");
        String deterministic = properties.get("Deterministic");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (routineKind != null) {
            this.setRoutineKind(PropertyConverter.importDasRoutineKind(routineKind));
        }
        if (deterministic != null) {
            this.setDeterministic(PropertyConverter.importBoolean(deterministic));
        }
    }
}

