/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.h2;

import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.h2.H2ModSchema;
import com.intellij.database.model.h2.H2Sequence;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface H2ModSequence
extends H2Sequence,
BasicModNamedElement {
    @Override
    @NotNull
    public H2ModSchema getSchema();

    @Override
    @NotNull
    default public H2ModSchema getDbParent() {
        H2ModSchema h2ModSchema = this.getSchema();
        if (h2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModSequence", "getDbParent"));
        }
        return h2ModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModSequence> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModSequence", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModSequence", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    public void setIdentity(@Nullable SequenceIdentity var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/h2/H2ModSequence", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String identity = properties.get("Identity");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (identity != null) {
            this.setIdentity(PropertyConverter.importSequenceIdentity(identity));
        }
    }
}

