/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.db2;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.db2.DB2Key;
import com.intellij.database.model.db2.DB2ModConstraint;
import com.intellij.database.model.db2.DB2ModSchema;
import com.intellij.database.model.db2.DB2ModTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DB2ModKey
extends DB2Key,
DB2ModConstraint,
BasicModKey {
    @Override
    @NotNull
    public DB2ModTable getTable();

    @Override
    @NotNull
    default public DB2ModTable getDbParent() {
        DB2ModTable dB2ModTable = this.getTable();
        if (dB2ModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/DB2ModKey", "getDbParent"));
        }
        return dB2ModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends DB2ModKey> getParentFamily();

    @Override
    @NotNull
    default public DB2ModSchema getSchema() {
        DB2ModSchema dB2ModSchema = this.getTable().getSchema();
        if (dB2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/DB2ModKey", "getSchema"));
        }
        return dB2ModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/DB2ModKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/DB2ModKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setPrimary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/db2/DB2ModKey", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String primary = properties.get("Primary");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (primary != null) {
            this.setPrimary(PropertyConverter.importBoolean(primary));
        }
    }
}

