/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicSchema
extends BasicNamespace,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicSchema", "getKind"));
        }
        return objectKind;
    }

    default public @Nullable NamingFamily<@NotNull ? extends BasicSchema> getParentFamily() {
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    default public BasicSchema getSibling(@Nullable String name) {
        if (name == null) {
            return null;
        }
        @NotNull Family family = this.getParentFamily();
        return family != null ? (BasicSchema)family.get(name) : null;
    }

    @Nullable
    default public BasicLikeTable getLikeTable(@Nullable String name) {
        return this.findChild(ModelConsts.LIKE_TABLE_KINDS, name, BasicLikeTable.class);
    }

    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }
}

