/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class TableColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableColumn> {
    private final DatabaseFamilyId myFamilyId;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final TIntHashSet myPositions;
    private String myPrevName;

    public TableColumnIt(@NotNull ResultSet rs, @NotNull ErrorHandler handler, @NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt", "<init>"));
        }
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt", "<init>"));
        }
        super(rs, handler);
        this.myPositions = new TIntHashSet();
        this.myFamilyId = familyId;
        this.mySchema = schema;
    }

    @Override
    protected @NotNull DatabaseMetaDataWrapper.TableColumn createStorage() {
        return new DatabaseMetaDataWrapper.TableColumn(new DatabaseMetaDataWrapper.Table(this.mySchema, ""));
    }

    @Override
    protected DatabaseMetaDataWrapper.TableColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableColumn res = (DatabaseMetaDataWrapper.TableColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Comparing.equal((String)this.mySchema.schema, (String)schema)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (!Comparing.equal((String)this.myPrevName, (String)table)) {
                this.myPositions.clear();
                this.myPrevName = table;
            }
            res.table.name = table;
            res.name = this.myRs.getString("COLUMN_NAME", 4);
            if (StringUtil.isEmpty((String)res.name)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            res.type = this.myRs.getInt("DATA_TYPE", 5, 0);
            res.typeName = StringUtil.notNullize((String)this.myRs.getString("TYPE_NAME", 6));
            res.length = this.myRs.getInt("COLUMN_SIZE", 7, 0);
            res.scale = this.myRs.getInt("DECIMAL_DIGITS", 9, 0);
            if (this.myFamilyId.isSqlite()) {
                res.length = 0;
                res.scale = -1;
            }
            res.nullable = this.myRs.getInt("NULLABLE", 11, 0) != 0;
            res.def = this.myRs.getString("COLUMN_DEF", 13);
            res.position = this.myRs.getInt("ORDINAL_POSITION", 17, 0);
            if (res.position == -1) {
                res.position = 0;
            }
            while (this.myPositions.contains(res.position)) {
                ++res.position;
            }
            this.myPositions.add(res.position);
            res.comment = this.myRs.getString("REMARKS", 12);
            String aincYN = this.myRs.getString("IS_AUTOINCREMENT", 23);
            res.autoIncrement = "yes".equalsIgnoreCase(aincYN);
            if (aincYN == null && this.myFamilyId.isTransactSql()) {
                res.autoIncrement = res.typeName != null && res.typeName.endsWith(" identity");
            }
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableColumn)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.table.schema.database, cur.table.schema.schema, cur.table.name);
        this.myErrorHandler.addError(title, (Throwable)e);
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn, DatabaseMetaDataWrapper.TableColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableColumn> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt$Grouping", "<init>"));
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            final String tableName = ((DatabaseMetaDataWrapper.TableColumn)it.current()).table.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableColumn item) {
                    return Comparing.equal((String)tableName, (String)item.table.name);
                }
            };
            if (groupIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt$Grouping", "createGroupIt"));
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.Table getItem(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            return ((DatabaseMetaDataWrapper.TableColumn)it.current()).table;
        }
    }
}

