/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.model.DasRoutine;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SybaseRoutineIt
extends ClosableIt.DelegateMutableIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.Routine> {
    private final DatabaseMetaDataWrapper.Schema mySchema;

    SybaseRoutineIt(@NotNull DatabaseMetaDataWrapper.Schema schema, Iterator<? extends DatabaseMetaDataWrapper.Table> it) {
        super(it);
        this.mySchema = schema;
    }

    @Override
    protected @NotNull DatabaseMetaDataWrapper.Routine createStorage() {
        return new DatabaseMetaDataWrapper.Routine(this.mySchema, null, "");
    }

    public static boolean isSybTableName(String name, String type) {
        return !"SYSTEM TABLE".equals(type) || name.startsWith("sys");
    }

    @Override
    protected DatabaseMetaDataWrapper.Routine calcValue(DatabaseMetaDataWrapper.Table cur) {
        if (cur == null) {
            return (DatabaseMetaDataWrapper.Routine)this.skip();
        }
        DatabaseMetaDataWrapper.Routine res = (DatabaseMetaDataWrapper.Routine)this.getStorageToFill();
        res.name = cur.name;
        res.specificName = cur.name;
        res.kind = DasRoutine.Kind.FUNCTION;
        res.comment = cur.comment;
        return res;
    }
}

