/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranspositionAwareDefaultExtractor<T extends DatabaseSettings.StdState>
extends DefaultValuesExtractor<T> {
    protected static final DataConsumer.Column ROW_NAMES_COLUMN = new DataConsumer.Column(0, "Column", 12, "", "");
    private boolean myTransposedMode;

    protected TranspositionAwareDefaultExtractor(@NotNull T state, @NotNull ObjectFormatter converter) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor", "<init>"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor", "<init>"));
        }
        super(state, converter);
    }

    public void setTransposedMode(boolean enabled) {
        this.myTransposedMode = enabled;
    }

    public boolean isTransposedMode() {
        return this.myTransposedMode;
    }

    @Override
    public String getValueLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor", "getValueLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor", "getValueLiteral"));
        }
        return super.getValueLiteral(dialect, value, TranspositionAwareDefaultExtractor.getOriginalRow(row, column), TranspositionAwareDefaultExtractor.getOriginalColumn(row, column));
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect, boolean forDisplay) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor", "getValueAsString"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor", "getValueAsString"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor", "getValueAsString"));
        }
        return super.getValueAsString(TranspositionAwareDefaultExtractor.getOriginalRow(row, column), TranspositionAwareDefaultExtractor.getOriginalColumn(row, column), dialect, forDisplay);
    }

    @Override
    public final DataExtractor.Extraction startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return this.startExtraction(out, dialect, forceSkipHeader, this.isTransposedMode(), allColumns, selectedColumns);
    }

    protected TranspositionAwareExtractionBase startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new TranspositionAwareExtractionBase(out, dialect, forceSkipHeader, transposedMode, allColumns, selectedColumns);
    }

    @Nullable
    protected static DataConsumer.Column getOriginalColumn(@Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        return row instanceof TransposedRow ? ((TransposedRow)row).originalColumn : column;
    }

    @Nullable
    protected static DataConsumer.Row getOriginalRow(@Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        return column instanceof TransposedColumn ? ((TransposedColumn)column).originalRow : row;
    }

    protected static class TransposedColumn
    extends DataConsumer.Column {
        public final DataConsumer.Row originalRow;

        public TransposedColumn(int columnNum, DataConsumer.Row originalRow) {
            super(columnNum, String.valueOf(originalRow.rowNum), 12, "", "");
            this.originalRow = originalRow;
        }
    }

    protected static class TransposedRow
    extends DataConsumer.Row {
        public final DataConsumer.Column originalColumn;

        public TransposedRow(int rowNum, Object[] values, DataConsumer.Column originalColumn) {
            super(rowNum, values);
            this.originalColumn = originalColumn;
        }
    }

    protected class TranspositionAwareExtractionBase
    extends DefaultValuesExtractor.DefaultExtraction {
        protected boolean myTranspose;

        public TranspositionAwareExtractionBase(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transpose, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(output, dialect, forceSkipHeader, allColumns, selectedColumnIndices);
            this.myTranspose = transpose;
        }

        @Override
        protected final void appendHeader(boolean appendNewLine) {
            if (!this.myTranspose) {
                this.doAppendHeader(appendNewLine);
            }
        }

        @Override
        protected final void appendData(List<DataConsumer.Row> rows) {
            if (!this.myTranspose) {
                this.doAppendData(rows);
            } else {
                this.doTransposedExtraction(rows);
            }
        }

        @Override
        protected final void appendFooter() {
            if (!this.myTranspose) {
                this.doAppendFooter();
            }
        }

        @Override
        @NotNull
        protected String getRowNumber(DataConsumer.Row row) {
            if (!this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0)) {
                Object rowNumber = ROW_NAMES_COLUMN.getValue(row);
                String string = rowNumber instanceof String ? (String)rowNumber : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor$TranspositionAwareExtractionBase", "getRowNumber"));
                }
                return string;
            }
            String string = super.getRowNumber(row);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor$TranspositionAwareExtractionBase", "getRowNumber"));
            }
            return string;
        }

        @Override
        @NotNull
        protected DataConsumer.Column getRowNumbersColumn() {
            DataConsumer.Column column = !this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0) ? ROW_NAMES_COLUMN : super.getRowNumbersColumn();
            if (column == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/TranspositionAwareDefaultExtractor$TranspositionAwareExtractionBase", "getRowNumbersColumn"));
            }
            return column;
        }

        protected void doTransposedExtraction(List<DataConsumer.Row> rows) {
            List<DataConsumer.Column> transposedColumns = this.getTransposedColumns(rows);
            int[] selectedColumns = new int[Math.max(0, transposedColumns.size() - 1)];
            for (int i2 = 0; i2 < selectedColumns.length; ++i2) {
                selectedColumns[i2] = i2 + 1;
            }
            TranspositionAwareExtractionBase e = TranspositionAwareDefaultExtractor.this.startExtraction(this.myOutput, this.myDialect, this.myForceSkipHeader, false, transposedColumns, selectedColumns);
            e.addData(this.getTransposedRows(rows));
            e.complete();
        }

        protected void doAppendHeader(boolean appendNewLine) {
            super.appendHeader(appendNewLine);
        }

        protected void doAppendData(List<DataConsumer.Row> rows) {
            super.appendData(rows);
        }

        protected void doAppendFooter() {
            super.appendFooter();
        }

        protected List<DataConsumer.Row> getTransposedRows(List<DataConsumer.Row> rows) {
            int[] originalSelection = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            ArrayList transposedRows = ContainerUtil.newArrayListWithCapacity((int)originalSelection.length);
            for (int i2 : originalSelection) {
                DataConsumer.Column column = (DataConsumer.Column)this.myAllColumns.get(i2);
                Object[] transposedRow = new Object[rows.size() + 1];
                transposedRow[0] = column.name;
                for (int j = 0; j < rows.size(); ++j) {
                    transposedRow[j + 1] = column.getValue(rows.get(j));
                }
                transposedRows.add(new TransposedRow(i2, transposedRow, column));
            }
            return transposedRows;
        }

        protected List<DataConsumer.Column> getTransposedColumns(List<DataConsumer.Row> rows) {
            ArrayList transposedColumns = ContainerUtil.newArrayListWithCapacity((int)(rows.size() + 1));
            transposedColumns.add(ROW_NAMES_COLUMN);
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                transposedColumns.add(new TransposedColumn(i2 + 1, rows.get(i2)));
            }
            return transposedColumns;
        }
    }
}

