/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SeparatedValuesExtractor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSeparatedExtractor
extends SeparatedValuesExtractor<DatabaseSettings.XsvState> {
    public CustomSeparatedExtractor(ObjectFormatter converter) {
        this(new DatabaseSettings.XsvState(), converter);
    }

    public CustomSeparatedExtractor(DatabaseSettings.XsvState state, ObjectFormatter converter) {
        super(state, converter);
    }

    @Override
    public String getOpeningQuote() {
        return StringUtil.unescapeStringCharacters((String)((DatabaseSettings.XsvState)this.myState).openingQuote);
    }

    public void setOpeningQuote(String openingQuote) {
        ((DatabaseSettings.XsvState)this.myState).openingQuote = this.escapeStringValue(openingQuote);
    }

    @Override
    public String getClosingQuote() {
        return StringUtil.unescapeStringCharacters((String)((DatabaseSettings.XsvState)this.myState).closingQuote);
    }

    public void setClosingQuote(String closingQuote) {
        ((DatabaseSettings.XsvState)this.myState).closingQuote = StringUtil.escapeStringCharacters((String)closingQuote);
    }

    @Override
    public String getLineSeparator() {
        return StringUtil.unescapeStringCharacters((String)((DatabaseSettings.XsvState)this.myState).lineSeparator);
    }

    public void setLineSeparator(String lineSeparator) {
        ((DatabaseSettings.XsvState)this.myState).lineSeparator = StringUtil.escapeStringCharacters((String)lineSeparator);
    }

    @Override
    public String getValueSeparator() {
        return StringUtil.unescapeStringCharacters((String)((DatabaseSettings.XsvState)this.myState).valueSeparator);
    }

    public void setValueSeparator(String separator) {
        ((DatabaseSettings.XsvState)this.myState).valueSeparator = StringUtil.escapeStringCharacters((String)separator);
    }

    @Override
    @NotNull
    public String getLinePrefix() {
        String string = StringUtil.unescapeStringCharacters((String)((DatabaseSettings.XsvState)this.myState).linePrefix);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/CustomSeparatedExtractor", "getLinePrefix"));
        }
        return string;
    }

    public void setLinePrefix(String linePrefix) {
        ((DatabaseSettings.XsvState)this.myState).linePrefix = this.escapeStringValue(linePrefix);
    }

    @Override
    @NotNull
    public String getLineSuffix() {
        String string = StringUtil.unescapeStringCharacters((String)((DatabaseSettings.XsvState)this.myState).lineSuffix);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/CustomSeparatedExtractor", "getLineSuffix"));
        }
        return string;
    }

    public void setLineSuffix(String lineSuffix) {
        ((DatabaseSettings.XsvState)this.myState).lineSuffix = StringUtil.escapeStringCharacters((String)lineSuffix);
    }

    public void setAlwaysQuote(boolean alwaysQuote) {
        ((DatabaseSettings.XsvState)this.myState).alwaysQuote = alwaysQuote;
    }

    @Override
    protected boolean isStringLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/CustomSeparatedExtractor", "isStringLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/CustomSeparatedExtractor", "isStringLiteral"));
        }
        return ((DatabaseSettings.XsvState)this.myState).alwaysQuote || super.isStringLiteral(dialect, value, row, column);
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("txt" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/CustomSeparatedExtractor", "getFileExtension"));
        }
        return "txt";
    }
}

