/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.Binding;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

public class ExtensionScriptsUtil {
    private ExtensionScriptsUtil() {
    }

    @Nullable
    public static IdeScriptEngine getEngineFor(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/extensions/ExtensionScriptsUtil", "getEngineFor"));
        }
        String scriptExtension = StringUtil.notNullize((String)file.getExtension());
        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)ObjectUtils.notNull((Object)PluginManager.getPlugin((PluginId)DatabasePluginId.get()));
        IdeScriptEngine engine = IdeScriptEngineManager.getInstance().getEngineForFileExtension(scriptExtension, descriptor.getPluginClassLoader());
        if (engine == null) {
            String title = "No script engine found for file extension '" + scriptExtension + "'";
            String content = "Please, make sure your script engine jar(s) and language runtime are in the IDE classpath.";
            ExtensionScriptsUtil.showError(project, title, content);
        }
        return engine;
    }

    @NotNull
    public static Binder setBindings(@NotNull IdeScriptEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/database/extensions/ExtensionScriptsUtil", "setBindings"));
        }
        Binder binder = new Binder(engine);
        if (binder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extensions/ExtensionScriptsUtil", "setBindings"));
        }
        return binder;
    }

    public static void prepareScript(@NotNull VirtualFile script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/database/extensions/ExtensionScriptsUtil", "prepareScript"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @NotNull
    public static String loadScript(@Nullable Project project, @NotNull VirtualFile script) throws IOException {
        String string;
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/database/extensions/ExtensionScriptsUtil", "loadScript"));
        }
        try {
            string = VfsUtilCore.loadText((VirtualFile)script);
        }
        catch (IOException e) {
            ExtensionScriptsUtil.showError(project, "Failed to load script: " + script.getPath(), ExceptionUtil.getThrowableText((Throwable)e));
            throw e;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extensions/ExtensionScriptsUtil", "loadScript"));
        }
        return string;
    }

    public static void evalScript(@Nullable Project project, @NotNull IdeScriptEngine engine, @NotNull String script) throws IdeScriptException {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/database/extensions/ExtensionScriptsUtil", "evalScript"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/database/extensions/ExtensionScriptsUtil", "evalScript"));
        }
        try {
            engine.eval(script);
        }
        catch (IdeScriptException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw e;
            }
            ExtensionScriptsUtil.showScriptExecutionError(project, ExceptionUtil.getRootCause((Throwable)e));
            throw e;
        }
    }

    public static void showScriptExecutionError(@Nullable Project project, @NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/extensions/ExtensionScriptsUtil", "showScriptExecutionError"));
        }
        ExtensionScriptsUtil.showError(project, "Script execution error", ExceptionUtil.getThrowableText((Throwable)error, (String)"com.intellij."));
    }

    public static void showError(@Nullable Project project, @NotNull String title, @NotNull String content) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/extensions/ExtensionScriptsUtil", "showError"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/extensions/ExtensionScriptsUtil", "showError"));
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, content, NotificationType.ERROR, null).notify(project);
    }

    public static class Binder {
        private final IdeScriptEngine myEngine;

        Binder(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/database/extensions/ExtensionScriptsUtil$Binder", "<init>"));
            }
            this.myEngine = engine;
        }

        @NotNull
        public <T> Binder bind(@NotNull Binding<T> what, @Nullable T to) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/database/extensions/ExtensionScriptsUtil$Binder", "bind"));
            }
            this.myEngine.setBinding(what.name, to);
            Binder binder = this;
            if (binder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extensions/ExtensionScriptsUtil$Binder", "bind"));
            }
            return binder;
        }
    }
}

