/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class TableFileEditor
extends TableEditorBase
implements DocumentReferenceProvider {
    private final VirtualFile myFile;

    protected TableFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/TableFileEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/TableFileEditor", "<init>"));
        }
        super(project);
        this.myFile = file;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableFileEditor", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    protected final DataGrid createDataGrid(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/editor/TableFileEditor", "createDataGrid"));
        }
        ActionGroup popupActions = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PopupGroup");
        final DataGrid grid = DataGridUtil.createDataGrid(this.getProject(), hookUp, popupActions);
        Disposer.register((Disposable)this, (Disposable)grid);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector.Once((Component)grid.getComponent(), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                grid.getDataHookup().getLoader().loadFirstPage(GridRequestSource.create(grid, null));
            }
        }));
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.table.editor.wrapper");
        DataGrid dataGrid = grid;
        if (dataGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableFileEditor", "createDataGrid"));
        }
        return dataGrid;
    }
}

