/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.editor.DatabaseTableEditorLocation;
import com.intellij.database.editor.TableEditorStructureViewModel;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableEditorBase
extends UserDataHolderBase
implements FileEditor {
    private final Project myProject;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport((Object)this);

    protected TableEditorBase(Project project) {
        this.myProject = project;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public abstract DataGrid getDataGrid();

    @NotNull
    public String getName() {
        if ("Data" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorBase", "getName"));
        }
        return "Data";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/editor/TableEditorBase", "setState"));
        }
    }

    public void selectNotify() {
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(this.getProject());
        if (statusBar == null) {
            return;
        }
        statusBar.updateWidgets();
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/editor/TableEditorBase", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/editor/TableEditorBase", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @NotNull
    public DatabaseTableEditorLocation getCurrentLocation() {
        DatabaseTableEditorLocation databaseTableEditorLocation = new DatabaseTableEditorLocation(this, -1, -1);
        if (databaseTableEditorLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorBase", "getCurrentLocation"));
        }
        return databaseTableEditorLocation;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return new TreeBasedStructureViewBuilder(){

            public boolean isRootNodeShown() {
                return false;
            }

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                TableEditorStructureViewModel tableEditorStructureViewModel = new TableEditorStructureViewModel(TableEditorBase.this);
                if (tableEditorStructureViewModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorBase$1", "createStructureViewModel"));
                }
                return tableEditorStructureViewModel;
            }
        };
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.getDataGrid().getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorBase", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getDataGrid().getPreferredFocusedComponent();
    }
}

