/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MysqlArguments {
    public static final String[] FIELDS_OPT_ENCLOSED_BY = DbDumpUtil.withEquality("--fields-optionally-enclosed-by");
    public static final String[] INSERTS_WITH_COLUMNS = new String[]{"--complete-insert", "-c"};
    public static final String[] DEFAULTS_GROUP_SUFFIX = DbDumpUtil.withEquality("--defaults-group-suffix");
    public static final String[] SHARED_MEMORY_NAME = DbDumpUtil.withEquality("--shared-memory-base-name");
    public static final String[] FIELDS_TERMINATED_BY = DbDumpUtil.withEquality("--fields-terminated-by");
    public static final String[] LINES_TERMINATED_BY = DbDumpUtil.withEquality("--lines-terminated-by");
    public static final String[] PASSWORD_PARAMETERIZABLE = DbDumpUtil.withEquality("--password", "-p");
    public static final String[] EXTENDED_INSERTS = new String[]{"--extended-insert", "-e"};
    public static final String[] ALL_TABLESPACES = new String[]{"--all-tablespaces", "-Y"};
    public static final String[] LOCK_ALL_TABLES = new String[]{"--lock-all-tables", "-x"};
    public static final String[] DEFAULT_CHAR_SET = DbDumpUtil.withEquality("--default-character-set");
    public static final String[] DEFAULT_EXTRA_FILE = DbDumpUtil.withEquality("--defaults-extra-file");
    public static final String[] MAX_ALLOWED_PACKET = DbDumpUtil.withEquality("--max-allowed-packet");
    public static final String[] FIELDS_ENCLOSED_BY = DbDumpUtil.withEquality("--fields-enclosed-by");
    public static final String[] NO_CREATE_INFO = new String[]{"--no-create-info", "-t"};
    public static final String[] CREATE_OPTIONS = new String[]{"--create-options", "-a"};
    public static final String[] FIELDS_ESCAPED_BY = DbDumpUtil.withEquality("--fields-escaped-by");
    public static final String[] NET_BUFFER_LENGTH = DbDumpUtil.withEquality("--net-buffer-length");
    public static final String[] ALL_DATABASES = new String[]{"--all-databases", "-A"};
    public static final String[] NO_CREATE_DB = new String[]{"--no-create-db", "-n"};
    public static final String[] DISABLE_KEYS = new String[]{"--disable-keys", "-K"};
    public static final String[] CHAR_SETS_DIR = DbDumpUtil.withEquality("--character-sets-dir");
    public static final String[] SET_GTID_PURGED = DbDumpUtil.withEquality("--set-gtid-purged");
    public static final String[] LOCK_TABLES = new String[]{"--lock-tables", "-l"};
    public static final String[] QUOTE_NAMES = new String[]{"--quote-names", "-Q"};
    public static final String[] RESULT_FILE = DbDumpUtil.withEquality("--result-file", "-r");
    public static final String[] FLUSH_LOGS = new String[]{"--flush-logs", "-F"};
    public static final String[] DEFAULTS_FILE = DbDumpUtil.withEquality("--defaults-file");
    public static final String[] INSERT_IGNORE = DbDumpUtil.withEquality("--insert-ignore");
    public static final String[] DEFAULT_AUTH = DbDumpUtil.withEquality("--default-auth");
    public static final String[] DATABASES = DbDumpUtil.withEquality("--databases", "-B");
    public static final String[] BIND_ADDRESS = DbDumpUtil.withEquality("--bind-address");
    public static final String[] IGNORE_TABLE = DbDumpUtil.withEquality("--ignore-table");
    public static final String[] PASSWORD = new String[]{"--password", "-p"};
    public static final String[] ROUTINES = new String[]{"--routines", "-R"};
    public static final String[] COMMENTS = new String[]{"--comments", "-i"};
    public static final String[] COMPRESS = new String[]{"--compress", "-C"};
    public static final String[] SSL_CRL_PATH = DbDumpUtil.withEquality(MysqlArguments.ssl("-crlpath"));
    public static final String[] NO_TABLESPACES = new String[]{"--no-tablespaces", "-y"};
    public static final String[] MASTER_DATA = DbDumpUtil.withEquality("--master-data");
    public static final String[] SSL_CA_PATH = DbDumpUtil.withEquality(MysqlArguments.ssl("-capath"));
    public static final String[] NO_DATA = new String[]{"--no-data", "-d"};
    public static final String[] PLUGIN_DIR = DbDumpUtil.withEquality("--plugin-dir");
    public static final String[] DUMP_SLAVE = DbDumpUtil.withEquality("--dump-slave");
    public static final String[] SSL_CIPHER = DbDumpUtil.withEquality(MysqlArguments.ssl("-cipher"));
    public static final String[] COMPATIBLE = DbDumpUtil.withEquality("--compatible");
    public static final String[] EVENTS = new String[]{"--events", "-E"};
    public static final String[] LOG_ERROR = DbDumpUtil.withEquality("--log-error");
    public static final String[] NO_SET_NAMES = new String[]{"--no-set-names", "-N"};
    public static final String[] SOCKET = DbDumpUtil.withEquality("--socket", "-S");
    public static final String[] FORCE = new String[]{"--force", "-f"};
    public static final String[] QUICK = DbDumpUtil.withEquality("--quick", "-q");
    public static final String[] SSL_MODE = DbDumpUtil.withEquality(MysqlArguments.ssl("-mode"));
    public static final String[] DEBUG = DbDumpUtil.withEquality("--debug", "-#");
    public static final String[] PROTOCOL = DbDumpUtil.withEquality("--protocol");
    public static final String[] WHERE = DbDumpUtil.withEquality("--where", "-w");
    public static final String[] SSL_CERT = DbDumpUtil.withEquality(MysqlArguments.ssl("-cert"));
    public static final String[] PIPE = new String[]{"--pipe", "-W"};
    public static final String[] PORT = DbDumpUtil.withEquality("--port", "-P");
    public static final String[] USER = DbDumpUtil.withEquality("--user", "-u");
    public static final String[] SSL_KEY = DbDumpUtil.withEquality(MysqlArguments.ssl("-key"));
    public static final String[] HOST = DbDumpUtil.withEquality("--host", "-h");
    public static final String[] SSL_CRL = DbDumpUtil.withEquality(MysqlArguments.ssl("-crl"));
    public static final String[] TAB = DbDumpUtil.withEquality("--tab", "-T");
    public static final String[] SSL_CA = DbDumpUtil.withEquality(MysqlArguments.ssl("-ca"));
    public static final String[] VERBOSE = new String[]{"--verbose", "-v"};
    public static final String[] VERSION = new String[]{"--version", "-V"};
    public static final String[] XML = new String[]{"--xml", "-X"};
    public static final String ENABLE_CLEARTEXT_PLUGIN = "--enable-cleartext-plugin";
    public static final String APPLY_SLAVE_STATEMENTS = "--apply-slave-statements";
    public static final String SSL_VERIFY_SERVER_CERT = MysqlArguments.ssl("-verify-server-cert");
    public static final String MASTER_HOST_PORT = "--include-master-host-port";
    public static final String DELETE_MASTER_LOGS = "--delete-master-logs";
    public static final String SINGLE_TRANSACTION = "--single-transaction";
    public static final String DATABASES_PARAMETERIZABLE = "--databases=";
    public static final String ADD_DROP_TRIGGER = "--add-drop-trigger";
    public static final String ORDER_BY_PRIMARY = "--order-by-primary";
    public static final String FLUSH_PRIVILEGES = "--flush-privileges";
    public static final String ADD_DROP_TABLE = "--add-drop-table";
    public static final String PRINT_DEFAULTS = "--print-defaults";
    public static final String DELAYED_INSERTS = "--delayed-insert";
    public static final String ALLOW_KEYWORDS = "--allow-keywords";
    public static final String SKIP_COMMENTS = "--skip-comments";
    public static final String NO_AUTOCOMMIT = "--no-autocommit";
    public static final String NO_DEFAULTS = "--no-defaults";
    public static final String DEBUG_CHECK = "--debug-check";
    public static final String FIRST_SLAVE = "--first-slave";
    public static final String SECURE_AUTH = "--secure-auth";
    public static final String SET_CHARSET = "--set-charset";
    public static final String DEBUG_INFO = "--debug-info";
    public static final String ADD_LOCKS = "--add-locks";
    public static final String DUMP_DATE = "--dump-date";
    public static final String HEX_BLOB = "--hex-blob";
    public static final String SKIP_OPT = "--skip-opt";
    public static final String TRIGGERS = "--triggers";
    public static final String REPLACE = "--replace";
    public static final String COMPACT = "--compact";
    public static final String TABLES = "--tables";
    public static final String TZ_UTC = "--tz-utc";
    public static final String OPT = "--opt";
    public static final String SSL = MysqlArguments.ssl("");
    public static final String[] SKIP_EXTENDED_INSERTS = MysqlArguments.skip(EXTENDED_INSERTS);
    public static final String[] SKIP_CREATE_OPTIONS = MysqlArguments.skip(CREATE_OPTIONS);
    public static final String[] SKIP_DISABLE_KEYS = MysqlArguments.skip(DISABLE_KEYS);
    public static final String[] SKIP_QUOTE_NAMES = MysqlArguments.skip(QUOTE_NAMES);
    public static final String[] SKIP_LOCK_TABLES = MysqlArguments.skip(LOCK_TABLES);
    public static final String[] SKIP_QUICK = MysqlArguments.skip(QUICK);
    public static final String SKIP_ADD_DROP_TABLE = MysqlArguments.skip("--add-drop-table");
    public static final String SKIP_SET_CHARSET = MysqlArguments.skip("--set-charset");
    public static final String SKIP_SECURE_AUTH = MysqlArguments.skip("--secure-auth");
    public static final String SKIP_ADD_LOCKS = MysqlArguments.skip("--add-locks");
    public static final String SKIP_DUMP_DATE = MysqlArguments.skip("--dump-date");
    public static final String SKIP_TRIGGERS = MysqlArguments.skip("--triggers");
    public static final String SKIP_TZ_UTC = MysqlArguments.skip("--tz-utc");
    public static final String SKIP_SSL = MysqlArguments.skip(SSL);

    private MysqlArguments() {
    }

    @NotNull
    private static String[] skip(@NotNull String[] options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dump/dbdump/MysqlArguments", "skip"));
        }
        ArrayList list = ContainerUtil.newArrayList();
        for (String option : options) {
            if (!option.startsWith("--")) continue;
            list.add(new StringBuilder(option).insert(2, "skip-").toString());
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)list);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/MysqlArguments", "skip"));
        }
        return stringArray;
    }

    private static String skip(@NotNull String option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/dump/dbdump/MysqlArguments", "skip"));
        }
        return new StringBuilder(option).insert(2, "skip-").toString();
    }

    private static String ssl(@NotNull String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/database/dump/dbdump/MysqlArguments", "ssl"));
        }
        return "--ssl" + suffix;
    }
}

